/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.rya.api.domain.VarNameUtils;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.NAryValueOperator;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class QueryVariableNormalizer {
    public static List<TupleExpr> getNormalizedIndex(TupleExpr tuple1, TupleExpr tuple2) throws Exception {
        List filters1;
        List<HashMap<String, String>> varChanges = new ArrayList<HashMap<String, String>>();
        ArrayList<TupleExpr> tupleList = new ArrayList<TupleExpr>();
        if (tuple1.equals(tuple2)) {
            tupleList.add(tuple1.clone());
            return tupleList;
        }
        NormalizeQueryVisitor tupNVis = new NormalizeQueryVisitor(false);
        NormalizeQueryVisitor indexNVis = new NormalizeQueryVisitor(true);
        tuple1.visit((QueryModelVisitor)tupNVis);
        tuple2.visit((QueryModelVisitor)indexNVis);
        TreeMap queryMap1 = tupNVis.getMap();
        TreeMap indexMap1 = indexNVis.getMap();
        TreeMap[] trees = new TreeMap[4];
        for (int i = 0; i < 4; ++i) {
            trees[i] = new TreeMap();
        }
        trees[0] = tupNVis.getKeyMap();
        trees[2] = indexNVis.getKeyMap();
        Set keys = indexMap1.keySet();
        ArrayList keyList = new ArrayList(keys);
        Collections.sort(keyList, new ConstantKeyComp(indexMap1, queryMap1));
        for (String s : keyList) {
            if (queryMap1.containsKey(s)) {
                List nodes1 = (List)queryMap1.get(s);
                List nodes2 = (List)indexMap1.get(s);
                if (nodes1.size() < nodes2.size()) {
                    return tupleList;
                }
                trees[1] = QueryVariableNormalizer.getListVarCnt(nodes1, tupNVis.getVariableMap());
                trees[3] = QueryVariableNormalizer.getListVarCnt(nodes2, indexNVis.getVariableMap());
                Collections.sort(nodes1, new CountComp(trees[1], trees[0]));
                Collections.sort(nodes2, new CountComp(trees[3], trees[2]));
                if ((varChanges = QueryVariableNormalizer.statementCompare(nodes1, nodes2, varChanges, trees)).size() != 0) continue;
                return tupleList;
            }
            return tupleList;
        }
        List filters2 = indexNVis.getFilters();
        if (filters2.size() != 0 && (filters1 = tupNVis.getFilters()).size() >= filters2.size()) {
            Collections.sort(filters1, new FilterComp());
            Collections.sort(filters2, new FilterComp());
            varChanges = QueryVariableNormalizer.statementCompare(filters1, filters2, varChanges, trees);
        }
        ArrayList<HashMap> varChangeSet = new ArrayList<HashMap>();
        for (HashMap hashMap : varChanges) {
            if (varChangeSet.contains(hashMap)) continue;
            varChangeSet.add(hashMap);
        }
        ValueMapVisitor valMapVis = new ValueMapVisitor();
        tuple1.visit((QueryModelVisitor)valMapVis);
        Map<String, Value> map = valMapVis.getValueMap();
        for (HashMap s : varChangeSet) {
            TupleExpr tuple = tuple2.clone();
            QueryVariableNormalizer.replaceTupleVariables(s, tuple, map);
            tupleList.add(tuple);
        }
        return tupleList;
    }

    private static List<HashMap<String, String>> statementCompare(List<QueryModelNode> qArray, List<QueryModelNode> iArray, List<HashMap<String, String>> hMaps, TreeMap<String, Integer>[] trees) {
        if (hMaps.size() == 0) {
            HashMap<HashMap<String, String>, Boolean> mapConsistent = new HashMap<HashMap<String, String>, Boolean>();
            HashMap<String, String> hMap = new HashMap<String, String>();
            mapConsistent.put(hMap, false);
            QueryVariableNormalizer.evaluateMap(qArray, iArray, hMap, hMaps, mapConsistent, trees);
            return hMaps;
        }
        ArrayList tempMaps = Lists.newArrayList(hMaps);
        HashMap<HashMap<String, String>, Boolean> mapConsistent = new HashMap<HashMap<String, String>, Boolean>();
        for (HashMap<String, String> s : hMaps) {
            mapConsistent.put(s, false);
        }
        for (HashMap<String, String> s : hMaps) {
            QueryVariableNormalizer.evaluateMap(qArray, iArray, s, tempMaps, mapConsistent, trees);
        }
        return tempMaps;
    }

    private static void evaluateMap(List<QueryModelNode> qArray, List<QueryModelNode> iArray, HashMap<String, String> hMap, List<HashMap<String, String>> hMaps, HashMap<HashMap<String, String>, Boolean> mapConsistent, TreeMap<String, Integer>[] trees) throws IllegalArgumentException {
        if (iArray.size() == 0) {
            if (!hMaps.contains(hMap)) {
                hMaps.add(hMap);
            }
            mapConsistent.put(hMap, true);
            return;
        }
        for (int i = 0; i < iArray.size(); ++i) {
            for (int j = 0; j < qArray.size(); ++j) {
                ArrayList indexArray;
                ArrayList queryArray;
                HashMap hashMap;
                List<String> vars2;
                List<QueryModelNode> variables2;
                List<QueryModelNode> variables1;
                List<List<String>> vars;
                List<String> vars1;
                QueryModelNode node1 = qArray.get(j);
                QueryModelNode node2 = iArray.get(i);
                if (node1 instanceof StatementPattern && node2 instanceof StatementPattern) {
                    if (!QueryVariableNormalizer.genConstantCompare((StatementPattern)node1, (StatementPattern)node2) || !QueryVariableNormalizer.listConsistent(vars1 = (vars = QueryVariableNormalizer.genGetCommonVars(variables1 = ((StatementPattern)node1).getVarList(), (List<Var>)(variables2 = ((StatementPattern)node2).getVarList()))).get(0), vars2 = vars.get(1), hMap)) continue;
                    hashMap = Maps.newHashMap(hMap);
                    QueryVariableNormalizer.putVars(vars1, vars2, hashMap);
                    queryArray = Lists.newArrayList(qArray);
                    indexArray = Lists.newArrayList(iArray);
                    indexArray.remove(i);
                    queryArray.remove(j);
                    QueryVariableNormalizer.evaluateMap(queryArray, indexArray, hashMap, hMaps, mapConsistent, trees);
                    continue;
                }
                if (node1 instanceof Filter && node2 instanceof Filter) {
                    try {
                        if (!QueryVariableNormalizer.filterCompare((Filter)node1, (Filter)node2) || !QueryVariableNormalizer.listConsistent(vars1 = (vars = QueryVariableNormalizer.filterCommonVars(variables1 = FilterVarValueCollector.process((QueryModelNode)((Filter)node1).getCondition()), variables2 = FilterVarValueCollector.process((QueryModelNode)((Filter)node2).getCondition()))).get(0), vars2 = vars.get(1), hMap)) continue;
                        hashMap = Maps.newHashMap(hMap);
                        QueryVariableNormalizer.putVars(vars1, vars2, hashMap);
                        queryArray = Lists.newArrayList(qArray);
                        indexArray = Lists.newArrayList(iArray);
                        indexArray.remove(i);
                        queryArray.remove(j);
                        QueryVariableNormalizer.evaluateMap(queryArray, indexArray, hashMap, hMaps, mapConsistent, trees);
                    }
                    catch (Exception e) {
                        System.out.println("Invalid Filter! " + e);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Invalid query tree.");
            }
        }
        if (mapConsistent.containsKey(hMap) && !mapConsistent.get(hMap).booleanValue()) {
            hMaps.remove(hMap);
        }
    }

    private static List<List<String>> genGetCommonVars(List<Var> vars1, List<Var> vars2) {
        ArrayList varList = Lists.newArrayList();
        ArrayList varList1 = Lists.newArrayList();
        ArrayList varList2 = Lists.newArrayList();
        for (int i = 0; i < vars1.size(); ++i) {
            if (!vars1.get(i).isConstant() && !vars2.get(i).isConstant()) {
                varList1.add(vars1.get(i).getName());
                varList2.add(vars2.get(i).getName());
                continue;
            }
            if (!vars1.get(i).isConstant() || vars2.get(i).isConstant()) continue;
            varList1.add(vars1.get(i).getName());
            varList2.add(vars2.get(i).getName());
        }
        varList.add(varList1);
        varList.add(varList2);
        return varList;
    }

    private static List<List<String>> filterCommonVars(List<QueryModelNode> vars1, List<QueryModelNode> vars2) {
        ArrayList varList = Lists.newArrayList();
        ArrayList varList1 = Lists.newArrayList();
        ArrayList varList2 = Lists.newArrayList();
        for (int i = 0; i < vars1.size(); ++i) {
            if (vars1.get(i) instanceof ValueConstant && vars2.get(i) instanceof Var) {
                ValueConstant vc = (ValueConstant)vars1.get(i);
                String s = VarNameUtils.createUniqueConstVarName((Value)vc.getValue());
                varList1.add(s);
                varList2.add(((Var)vars2.get(i)).getName());
                continue;
            }
            if (vars1.get(i) instanceof ValueConstant) continue;
            if (!((Var)vars1.get(i)).isConstant() && vars2.get(i) instanceof Var && !((Var)vars2.get(i)).isConstant()) {
                varList1.add(((Var)vars1.get(i)).getName());
                varList2.add(((Var)vars2.get(i)).getName());
                continue;
            }
            if (!((Var)vars1.get(i)).isConstant() || !(vars2.get(i) instanceof Var) || ((Var)vars2.get(i)).isConstant()) continue;
            varList1.add(((Var)vars1.get(i)).getName());
            varList2.add(((Var)vars2.get(i)).getName());
        }
        varList.add(varList1);
        varList.add(varList2);
        return varList;
    }

    private static boolean genConstantCompare(StatementPattern queryNode, StatementPattern indexNode) {
        ArrayList vars1 = (ArrayList)queryNode.getVarList();
        ArrayList vars2 = (ArrayList)indexNode.getVarList();
        for (int i = 0; i < vars1.size(); ++i) {
            if (!(((Var)vars1.get(i)).isConstant() && ((Var)vars2.get(i)).isConstant() ? !((Var)vars1.get(i)).equals(vars2.get(i)) : !((Var)vars1.get(i)).isConstant() && ((Var)vars2.get(i)).isConstant())) continue;
            return false;
        }
        return true;
    }

    private static boolean checkVariables(String val, String key, HashMap<String, String> hMap) {
        if (!hMap.containsKey(key) && !hMap.containsValue(val)) {
            return true;
        }
        if (!hMap.containsKey(key) && hMap.containsValue(val) || hMap.containsKey(key) && !hMap.containsValue(val)) {
            return false;
        }
        return hMap.get(key).equals(val);
    }

    private static boolean listConsistent(List<String> varList1, List<String> varList2, HashMap<String, String> hMap) {
        for (int k = 0; k < varList1.size(); ++k) {
            String s2;
            String s1 = varList1.get(k);
            if (QueryVariableNormalizer.checkVariables(s1, s2 = varList2.get(k), hMap)) continue;
            return false;
        }
        return true;
    }

    private static void putVars(List<String> varList1, List<String> varList2, HashMap<String, String> hashMap) {
        for (int k = 0; k < varList1.size(); ++k) {
            String s1 = varList1.get(k);
            String s2 = varList2.get(k);
            if (hashMap.containsKey(s2)) continue;
            hashMap.put(s2, s1);
        }
    }

    private static boolean filterCompare(Filter filter1, Filter filter2) throws Exception {
        NodeCollector nc1 = new NodeCollector();
        NodeCollector nc2 = new NodeCollector();
        filter1.getCondition().visit((QueryModelVisitor)nc1);
        filter2.getCondition().visit((QueryModelVisitor)nc2);
        List<QueryModelNode> nodeList1 = nc1.getNodes();
        List<QueryModelNode> nodeList2 = nc2.getNodes();
        if (nodeList1.size() != nodeList2.size()) {
            return false;
        }
        for (int i = 0; i < nodeList1.size(); ++i) {
            if (nodeList1.get(i) instanceof ValueConstant && nodeList2.get(i) instanceof Var || nodeList1.get(i).getClass() == nodeList2.get(i).getClass()) continue;
            return false;
        }
        return true;
    }

    private static void replaceTupleVariables(HashMap<String, String> varChanges, TupleExpr tuple, Map<String, Value> valMap) throws Exception {
        TupleVarRenamer visitor = new TupleVarRenamer(varChanges, valMap);
        tuple.visit((QueryModelVisitor)visitor);
    }

    private static TreeMap<String, Integer> getListVarCnt(List<QueryModelNode> list, TreeMap<String, Integer> cnt) {
        int count = 0;
        for (QueryModelNode qNode : list) {
            List<String> vars = VarCollector.process(qNode);
            for (String s : vars) {
                count = cnt.get(s);
                cnt.put(s, ++count);
            }
        }
        return cnt;
    }

    private static int getSpCount(QueryModelNode sp, TreeMap<String, Integer> listCount, TreeMap<String, Integer> tupCount) {
        int spCount = 0;
        List<String> vars = VarCollector.process(sp);
        for (String var : vars) {
            spCount = spCount + listCount.get(var) + tupCount.get(var);
        }
        return spCount;
    }

    public static NormalizeQueryVisitor getVisitor(boolean isIndex) {
        return new NormalizeQueryVisitor(isIndex);
    }

    public static class NormalizeQueryVisitor
    extends AbstractQueryModelVisitor<Exception> {
        private TreeMap<String, List<QueryModelNode>> map = new TreeMap();
        private TreeMap<String, Integer> varMap = new TreeMap();
        private TreeMap<String, Integer> emptyVarMap = new TreeMap();
        private List<StatementPattern> statementList = new ArrayList<StatementPattern>();
        private List<QueryModelNode> filters = new ArrayList<QueryModelNode>();
        private boolean isIndex;

        public NormalizeQueryVisitor(boolean isIndex) {
            this.isIndex = isIndex;
        }

        private TreeMap<String, List<QueryModelNode>> getMap() {
            return this.map;
        }

        private TreeMap<String, Integer> getKeyMap() {
            return this.varMap;
        }

        private TreeMap<String, Integer> getVariableMap() {
            return this.emptyVarMap;
        }

        public List<StatementPattern> getStatementPatterns() {
            return this.statementList;
        }

        private List<QueryModelNode> getFilters() {
            return this.filters;
        }

        public void meet(StatementPattern node) throws Exception {
            this.statementList.add(node);
            String s = "";
            String t = "";
            Var node1 = node.getSubjectVar();
            Var node2 = node.getObjectVar();
            Var node3 = node.getPredicateVar();
            Var node4 = node.getContextVar();
            String s1 = "";
            String s2 = "";
            String s3 = "";
            String s4 = "";
            if (node1.isConstant()) {
                s1 = node1.getName().substring(7);
            }
            if (node2.isConstant()) {
                s2 = node2.getName().substring(7);
            }
            if (node3.isConstant()) {
                s3 = node3.getName().substring(7);
            }
            if (node4 != null && node4.isConstant()) {
                s4 = node4.getName().substring(7);
            }
            if ((s1 + s2 + s3).length() == 0) {
                s = "Nonconstant nodes have no variables.";
            }
            if (s.length() > 0) {
                List<Object> nodes;
                if (this.map.containsKey(s)) {
                    nodes = this.map.get(s);
                    nodes.add(node);
                } else {
                    nodes = new ArrayList<StatementPattern>();
                    nodes.add(node);
                }
                this.map.put(s, nodes);
            } else if (this.isIndex) {
                List<Object> nodes;
                t = s1 + s2 + s3 + s4;
                if (this.map.containsKey(t)) {
                    nodes = this.map.get(t);
                    nodes.add(node);
                } else {
                    nodes = new ArrayList<StatementPattern>();
                    nodes.add(node);
                }
                this.map.put(t, nodes);
            } else {
                List<Object> nodes;
                String[] comps = new String[]{s1, s2, s3, s4};
                for (int i = 0; i < 3; ++i) {
                    if (comps[i].length() == 0) continue;
                    if (this.map.containsKey(comps[i] + comps[3])) {
                        nodes = this.map.get(comps[i] + comps[3]);
                        nodes.add(node);
                    } else {
                        nodes = new ArrayList<StatementPattern>();
                        nodes.add(node);
                    }
                    this.map.put(comps[i] + comps[3], nodes);
                    for (int j = i + 1; j < 3; ++j) {
                        if (comps[j].length() == 0) continue;
                        if (this.map.containsKey(comps[i] + comps[j] + comps[3])) {
                            nodes = this.map.get(comps[i] + comps[j] + comps[3]);
                            nodes.add(node);
                        } else {
                            nodes = new ArrayList();
                            nodes.add(node);
                        }
                        this.map.put(comps[i] + comps[j] + comps[3], nodes);
                    }
                }
                if (s1.length() != 0 && s2.length() != 0 && s3.length() != 0) {
                    if (this.map.containsKey(s1 + s2 + s3 + s4)) {
                        nodes = this.map.get(s1 + s2 + s3 + s4);
                        nodes.add(node);
                    } else {
                        nodes = new ArrayList();
                        nodes.add(node);
                    }
                    this.map.put(s1 + s2 + s3 + s4, nodes);
                }
            }
            super.meet(node);
        }

        public void meet(Var node) throws Exception {
            int count = 1;
            if (!node.isConstant()) {
                if (this.varMap.containsKey(node.getName())) {
                    count = this.varMap.get(node.getName());
                    this.varMap.put(node.getName(), ++count);
                } else {
                    this.varMap.put(node.getName(), 1);
                }
                if (!this.emptyVarMap.containsKey(node.getName())) {
                    this.emptyVarMap.put(node.getName(), 0);
                }
            }
            super.meet(node);
        }

        public void meet(Filter filter) throws Exception {
            this.filters.add((QueryModelNode)filter);
            super.meet(filter);
        }
    }

    public static class FilterVarValueCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private List<QueryModelNode> vars = Lists.newArrayList();

        public static List<QueryModelNode> process(QueryModelNode node) {
            FilterVarValueCollector collector = new FilterVarValueCollector();
            node.visit((QueryModelVisitor)collector);
            return collector.getVars();
        }

        public List<QueryModelNode> getVars() {
            return this.vars;
        }

        public void meet(Var node) {
            this.vars.add((QueryModelNode)node);
        }

        public void meet(ValueConstant node) {
            this.vars.add((QueryModelNode)node);
        }
    }

    public static class VarCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private List<String> varNames = new ArrayList<String>();
        private List<Var> vars = Lists.newArrayList();

        public static List<String> process(QueryModelNode node) {
            VarCollector collector = new VarCollector();
            node.visit((QueryModelVisitor)collector);
            return collector.getVarNames();
        }

        public static List<Var> processVar(QueryModelNode node) {
            VarCollector collector = new VarCollector();
            node.visit((QueryModelVisitor)collector);
            return collector.getVars();
        }

        public List<String> getVarNames() {
            return this.varNames;
        }

        public List<Var> getVars() {
            return this.vars;
        }

        public void meet(Var var) {
            if (!var.hasValue()) {
                this.varNames.add(var.getName());
            }
            this.vars.add(var);
        }
    }

    public static class TupleVarRenamer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final HashMap<String, String> varChanges;
        private Map<String, Value> valMap;

        public TupleVarRenamer(HashMap<String, String> varChanges, Map<String, Value> valMap) {
            this.varChanges = varChanges;
            this.valMap = valMap;
        }

        public void meet(ProjectionElemList node) {
            List proj = node.getElements();
            for (ProjectionElem s : proj) {
                if (!this.varChanges.containsKey(s.getSourceName())) continue;
                String name = s.getSourceName();
                s.setSourceName(this.varChanges.get(name));
                s.setTargetName(this.varChanges.get(name));
            }
        }

        public void meet(StatementPattern node) {
            SpVarReNamer spv = new SpVarReNamer(this.varChanges, this.valMap);
            node.visit((QueryModelVisitor)spv);
        }

        public void meet(Filter node) {
            FilterVarReNamer fvr = new FilterVarReNamer(this.varChanges, this.valMap);
            node.getCondition().visit((QueryModelVisitor)fvr);
            node.getArg().visit((QueryModelVisitor)this);
        }
    }

    public static class FilterVarReNamer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final HashMap<String, String> hMap;
        private Map<String, Value> valMap;

        public FilterVarReNamer(HashMap<String, String> hMap, Map<String, Value> valMap) {
            this.valMap = valMap;
            this.hMap = hMap;
        }

        public void meet(Var var) {
            if (!(var.getParentNode() instanceof NAryValueOperator) && !var.isConstant() && this.hMap.containsKey(var.getName())) {
                String val = this.hMap.get(var.getName());
                if (VarNameUtils.isConstant((String)val)) {
                    var.replaceWith((QueryModelNode)new ValueConstant(this.valMap.get(val)));
                } else {
                    var.setName(val);
                }
            }
        }

        public void meetNAryValueOperator(NAryValueOperator node) {
            List oldValues = node.getArguments();
            ArrayList newValues = Lists.newArrayList();
            for (ValueExpr v : oldValues) {
                if (v instanceof Var) {
                    Var var = (Var)v;
                    if (var.isConstant() && this.hMap.containsKey(var.getName())) continue;
                    String val = this.hMap.get(var.getName());
                    if (VarNameUtils.isConstant((String)val)) {
                        newValues.add(new ValueConstant(this.valMap.get(val)));
                        continue;
                    }
                    var.setName(val);
                    newValues.add(var);
                    continue;
                }
                newValues.add(v);
            }
            node.setArguments((List)newValues);
        }
    }

    public static class SpVarReNamer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final HashMap<String, String> hMap;
        private Map<String, Value> valMap;

        public SpVarReNamer(HashMap<String, String> hMap, Map<String, Value> valMap) {
            this.valMap = valMap;
            this.hMap = hMap;
        }

        public void meet(Var var) {
            if (!var.isConstant() && this.hMap.containsKey(var.getName())) {
                String val = this.hMap.get(var.getName());
                if (VarNameUtils.isConstant((String)val)) {
                    var.setName(val);
                    var.setValue(this.valMap.get(val));
                    var.setAnonymous(true);
                } else {
                    var.setName(val);
                }
            }
        }
    }

    public static class NodeCollector
    extends AbstractQueryModelVisitor<Exception> {
        private List<QueryModelNode> nodes = Lists.newArrayList();

        public List<QueryModelNode> getNodes() {
            return this.nodes;
        }

        public void meetNode(QueryModelNode node) throws Exception {
            this.nodes.add(node);
            super.meetNode(node);
        }
    }

    public static class ValueMapVisitor
    extends AbstractQueryModelVisitor<Exception> {
        private Map<String, Value> valMap = Maps.newHashMap();

        public Map<String, Value> getValueMap() {
            return this.valMap;
        }

        public void meet(Var var) {
            if (var.isConstant()) {
                this.valMap.put(var.getName(), var.getValue());
            }
        }

        public void meet(ValueConstant val) {
            String s = VarNameUtils.createUniqueConstVarName((Value)val.getValue());
            this.valMap.put(s, val.getValue());
        }
    }

    public static class FilterComp
    implements Comparator<QueryModelNode> {
        @Override
        public int compare(QueryModelNode q1, QueryModelNode q2) {
            int size1 = VarCollector.process(q1).size();
            int size2 = VarCollector.process(q2).size();
            return size1 - size2;
        }
    }

    public static class ConstantKeyComp
    implements Comparator<String> {
        private TreeMap<String, List<QueryModelNode>> indexMap;
        private TreeMap<String, List<QueryModelNode>> queryMap;

        public ConstantKeyComp(TreeMap<String, List<QueryModelNode>> indexMap, TreeMap<String, List<QueryModelNode>> queryMap) {
            this.indexMap = indexMap;
            this.queryMap = queryMap;
        }

        @Override
        public int compare(String key1, String key2) {
            int len1 = 0;
            int len2 = 0;
            if (this.queryMap.containsKey(key1) && this.indexMap.containsKey(key1)) {
                len1 = this.indexMap.get(key1).size() + this.queryMap.get(key1).size();
            }
            if (this.queryMap.containsKey(key2) && this.indexMap.containsKey(key2)) {
                len2 = this.indexMap.get(key2).size() + this.queryMap.get(key2).size();
            }
            return len1 - len2;
        }
    }

    public static class CountComp
    implements Comparator<QueryModelNode> {
        private TreeMap<String, Integer> lCount;
        private TreeMap<String, Integer> tupleCount;

        public CountComp(TreeMap<String, Integer> lCount, TreeMap<String, Integer> tupleCount) {
            this.lCount = lCount;
            this.tupleCount = tupleCount;
        }

        @Override
        public int compare(QueryModelNode sp1, QueryModelNode sp2) {
            return -(QueryVariableNormalizer.getSpCount(sp1, this.lCount, this.tupleCount) - QueryVariableNormalizer.getSpCount(sp2, this.lCount, this.tupleCount));
        }
    }
}

