/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching;

import com.google.common.base.Preconditions;
import org.apache.rya.indexing.external.matching.ExternalSetConverter;
import org.apache.rya.indexing.external.matching.JoinSegment;
import org.apache.rya.indexing.external.matching.OptionalJoinSegment;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.PCJOptimizerUtilities;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class PCJToSegmentConverter
implements ExternalSetConverter<ExternalTupleSet> {
    private static final PCJToOptionalJoinSegment optional = new PCJToOptionalJoinSegment();
    private static final PCJToJoinSegment join = new PCJToJoinSegment();

    @Override
    public QuerySegment<ExternalTupleSet> setToSegment(ExternalTupleSet set) {
        Preconditions.checkNotNull((Object)((Object)set));
        if (PCJOptimizerUtilities.tupleContainsLeftJoins((TupleExpr)set.getTupleExpr())) {
            return optional.getSegment(set);
        }
        return join.getSegment(set);
    }

    static class PCJToOptionalJoinSegment
    extends AbstractQueryModelVisitor<RuntimeException> {
        private OptionalJoinSegment<ExternalTupleSet> segment;

        private PCJToOptionalJoinSegment() {
        }

        public QuerySegment<ExternalTupleSet> getSegment(ExternalTupleSet pcj) {
            this.segment = null;
            pcj.getTupleExpr().visit((QueryModelVisitor)this);
            return this.segment;
        }

        public void meet(Join join) {
            this.segment = new OptionalJoinSegment(join);
        }

        public void meet(Filter filter) {
            this.segment = new OptionalJoinSegment(filter);
        }

        public void meet(LeftJoin node) {
            this.segment = new OptionalJoinSegment(node);
        }
    }

    static class PCJToJoinSegment
    extends AbstractQueryModelVisitor<RuntimeException> {
        private JoinSegment<ExternalTupleSet> segment;

        private PCJToJoinSegment() {
        }

        public QuerySegment<ExternalTupleSet> getSegment(ExternalTupleSet pcj) {
            this.segment = null;
            pcj.getTupleExpr().visit((QueryModelVisitor)this);
            return this.segment;
        }

        public void meet(Join join) {
            this.segment = new JoinSegment(join);
        }

        public void meet(Filter filter) {
            this.segment = new JoinSegment(filter);
        }
    }
}

