/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.pcj.matching.QueryVariableNormalizer;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;

public class PCJOptimizerUtilities {
    public static boolean isPCJValid(TupleExpr node) {
        ValidQueryVisitor vqv = new ValidQueryVisitor();
        node.visit((QueryModelVisitor)vqv);
        if (vqv.isValid() && (vqv.getJoinCount() > 0 || vqv.getFilters().size() > 0 && vqv.getSPs().size() > 0)) {
            if (vqv.getFilters().size() > 0) {
                Set<String> spVars = PCJOptimizerUtilities.getVarNames(vqv.getSPs());
                Set<String> fVarNames = PCJOptimizerUtilities.getVarNames(vqv.getFilters());
                return spVars.containsAll(fVarNames);
            }
            return true;
        }
        return false;
    }

    public static boolean isPCJValid(ExternalTupleSet node) {
        return PCJOptimizerUtilities.isPCJValid((TupleExpr)node.getTupleExpr());
    }

    public static List<ExternalTupleSet> getValidPCJs(List<ExternalTupleSet> pcjs) {
        Iterator<ExternalTupleSet> iterator = pcjs.iterator();
        while (iterator.hasNext()) {
            ExternalTupleSet pcj = iterator.next();
            if (PCJOptimizerUtilities.isPCJValid(pcj)) continue;
            iterator.remove();
        }
        return pcjs;
    }

    public static Projection getProjection(TupleExpr te) {
        ProjectionVisitor visitor = new ProjectionVisitor();
        te.visit((QueryModelVisitor)visitor);
        return visitor.node;
    }

    public static void relocateFilters(Set<Filter> filters) {
        for (Filter filter : filters) {
            FilterRelocator.relocate(filter);
        }
    }

    private static Set<String> getVarNames(Collection<QueryModelNode> nodes) {
        HashSet nodeVarNames = Sets.newHashSet();
        for (QueryModelNode s : nodes) {
            List<String> tempVars = QueryVariableNormalizer.VarCollector.process(s);
            for (String t : tempVars) {
                nodeVarNames.add(t);
            }
        }
        return nodeVarNames;
    }

    public static boolean tupleContainsLeftJoins(TupleExpr node) {
        LeftJoinVisitor lj = new LeftJoinVisitor();
        node.visit((QueryModelVisitor)lj);
        return lj.containsLeftJoin;
    }

    protected static class LeftJoinVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        boolean containsLeftJoin = false;

        protected LeftJoinVisitor() {
        }

        public boolean containsLeftJoin() {
            return this.containsLeftJoin;
        }

        public void meet(LeftJoin node) {
            this.containsLeftJoin = true;
        }
    }

    protected static class FilterRelocator
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected Filter filter;
        protected Set<String> filterVars;

        public FilterRelocator(Filter filter) {
            this.filter = filter;
            this.filterVars = VarNameCollector.process((QueryModelNode)filter.getCondition());
        }

        public static void relocate(Filter filter) {
            FilterRelocator fr = new FilterRelocator(filter);
            filter.visit((QueryModelVisitor)fr);
        }

        protected void meetNode(QueryModelNode node) {
            assert (node instanceof TupleExpr);
            if (node instanceof UnaryTupleOperator && ((UnaryTupleOperator)node).getArg().getBindingNames().containsAll(this.filterVars)) {
                ((UnaryTupleOperator)node).getArg().visit((QueryModelVisitor)this);
            }
            this.relocate(this.filter, (TupleExpr)node);
        }

        public void meet(Join join) {
            if (join.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join.getRightArg().visit((QueryModelVisitor)this);
            } else if (join.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join.getLeftArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, (TupleExpr)join);
            }
        }

        public void meet(Filter node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit((QueryModelVisitor)this);
            } else {
                this.relocate(this.filter, leftJoin.getLeftArg());
            }
        }

        public void meet(Union union) {
            boolean filterMoved = false;
            if (Sets.intersection((Set)union.getRightArg().getBindingNames(), this.filterVars).size() > 0) {
                this.relocate(this.filter, union.getRightArg());
                filterMoved = true;
            }
            if (Sets.intersection((Set)union.getLeftArg().getBindingNames(), this.filterVars).size() > 0) {
                if (filterMoved) {
                    Filter clone = new Filter(this.filter.getArg(), this.filter.getCondition().clone());
                    this.relocate(clone, union.getLeftArg());
                } else {
                    this.relocate(this.filter, union.getLeftArg());
                }
            }
        }

        public void meet(Difference node) {
            if (Sets.intersection((Set)node.getRightArg().getBindingNames(), this.filterVars).size() > 0) {
                this.relocate(this.filter, node.getRightArg());
            } else if (Sets.intersection((Set)node.getLeftArg().getBindingNames(), this.filterVars).size() > 0) {
                Filter clone = new Filter(this.filter.getArg(), this.filter.getCondition().clone());
                this.relocate(clone, node.getLeftArg());
            }
        }

        public void meet(Intersection node) {
            if (Sets.intersection((Set)node.getRightArg().getBindingNames(), this.filterVars).size() > 0) {
                this.relocate(this.filter, node.getRightArg());
            } else if (Sets.intersection((Set)node.getLeftArg().getBindingNames(), this.filterVars).size() > 0) {
                Filter clone = new Filter(this.filter.getArg(), this.filter.getCondition().clone());
                this.relocate(clone, node.getLeftArg());
            }
        }

        public void meet(EmptySet node) {
            if (this.filter.getParentNode() != null) {
                this.filter.replaceWith((QueryModelNode)this.filter.getArg());
            }
        }

        protected void relocate(Filter filter, TupleExpr newFilterArg) {
            if (!filter.getArg().equals(newFilterArg)) {
                if (filter.getParentNode() != null) {
                    filter.replaceWith((QueryModelNode)filter.getArg());
                }
                newFilterArg.replaceWith((QueryModelNode)filter);
                filter.setArg(newFilterArg);
            }
        }
    }

    private static class ValidQueryVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private boolean isValid = true;
        private final Set<QueryModelNode> filterSet = Sets.newHashSet();
        private final Set<QueryModelNode> spSet = Sets.newHashSet();
        private int joinCount = 0;

        private ValidQueryVisitor() {
        }

        public Set<QueryModelNode> getFilters() {
            return this.filterSet;
        }

        public Set<QueryModelNode> getSPs() {
            return this.spSet;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public int getJoinCount() {
            return this.joinCount;
        }

        public void meet(Projection node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Filter node) {
            this.filterSet.add((QueryModelNode)node.getCondition());
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(StatementPattern node) {
            this.spSet.add((QueryModelNode)node);
        }

        public void meet(Join node) {
            ++this.joinCount;
            super.meet(node);
        }

        public void meet(LeftJoin node) {
            ++this.joinCount;
            super.meet(node);
        }

        public void meetNode(QueryModelNode node) {
            if (!(node instanceof Join || node instanceof LeftJoin || node instanceof StatementPattern || node instanceof Var || node instanceof Union || node instanceof Filter || node instanceof Projection)) {
                this.isValid = false;
                return;
            }
            super.meetNode(node);
        }
    }

    static class ProjectionVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        Projection node = null;

        ProjectionVisitor() {
        }

        public void meet(Projection node) {
            this.node = node;
        }
    }
}

