/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.pcj.matching;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.external.matching.AbstractExternalSetOptimizer;
import org.apache.rya.indexing.external.matching.BasicRater;
import org.apache.rya.indexing.external.matching.ExternalSetMatcher;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.matching.TopOfQueryFilterRelocator;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.mongodb.pcj.MongoPcjIndexSetProvider;
import org.apache.rya.indexing.pcj.matching.PCJExternalSetMatcherFactory;
import org.apache.rya.indexing.pcj.matching.provider.AbstractPcjIndexSetProvider;
import org.apache.rya.indexing.pcj.matching.provider.AccumuloIndexSetProvider;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class PCJOptimizer
extends AbstractExternalSetOptimizer<ExternalTupleSet>
implements Configurable {
    private static final PCJExternalSetMatcherFactory factory = new PCJExternalSetMatcherFactory();
    private AbstractPcjIndexSetProvider provider;
    private Configuration conf;
    private boolean init = false;

    public PCJOptimizer() {
    }

    public PCJOptimizer(Configuration conf) {
        this.setConf(conf);
    }

    public PCJOptimizer(List<ExternalTupleSet> indices, boolean useOptimalPcj, AbstractPcjIndexSetProvider provider) {
        Preconditions.checkNotNull(indices);
        Preconditions.checkNotNull((Object)provider);
        this.conf = new Configuration();
        this.useOptimal = useOptimalPcj;
        this.provider = provider;
        this.init = true;
    }

    public final void setConf(Configuration conf) {
        Preconditions.checkNotNull((Object)conf);
        if (!this.init) {
            try {
                this.conf = conf;
                this.useOptimal = ConfigUtils.getUseOptimalPCJ(conf);
                if (conf instanceof StatefulMongoDBRdfConfiguration) {
                    StatefulMongoDBRdfConfiguration mongoConf = (StatefulMongoDBRdfConfiguration)conf;
                    this.provider = new MongoPcjIndexSetProvider(mongoConf);
                } else {
                    this.provider = new AccumuloIndexSetProvider(conf);
                }
            }
            catch (Exception e) {
                throw new Error(e);
            }
            this.init = true;
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        Preconditions.checkNotNull((Object)tupleExpr);
        tupleExpr = TopOfQueryFilterRelocator.moveFiltersToTop(tupleExpr);
        try {
            if (this.provider.size() <= 0) {
                return;
            }
            super.optimize(tupleExpr, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not populate Index Cache.", e);
        }
    }

    @Override
    protected ExternalSetMatcher<ExternalTupleSet> getMatcher(QuerySegment<ExternalTupleSet> segment) {
        return factory.getMatcher(segment);
    }

    @Override
    protected ExternalSetProvider<ExternalTupleSet> getProvider() {
        return this.provider;
    }

    @Override
    protected Optional<QueryNodeListRater> getNodeListRater(QuerySegment<ExternalTupleSet> segment) {
        return Optional.of((Object)new BasicRater(segment.getOrderedNodes()));
    }
}

