/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.update;

import java.util.Optional;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.mongodb.IndexingException;

public interface RyaObjectStorage<T> {
    public void create(T var1) throws ObjectAlreadyExistsException, ObjectStorageException;

    public Optional<T> get(RyaIRI var1) throws ObjectStorageException;

    public void update(T var1, T var2) throws StaleUpdateException, ObjectStorageException;

    public boolean delete(RyaIRI var1) throws ObjectStorageException;

    public static class StaleUpdateException
    extends ObjectStorageException {
        private static final long serialVersionUID = 1L;

        public StaleUpdateException(String message) {
            super(message);
        }

        public StaleUpdateException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ObjectAlreadyExistsException
    extends ObjectStorageException {
        private static final long serialVersionUID = 1L;

        public ObjectAlreadyExistsException(String message) {
            super(message);
        }

        public ObjectAlreadyExistsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ObjectStorageException
    extends IndexingException {
        private static final long serialVersionUID = 1L;

        public ObjectStorageException(String message) {
            super(message);
        }

        public ObjectStorageException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

