/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.update;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.rya.indexing.mongodb.IndexingException;

@DefaultAnnotation(value={NonNull.class})
public interface MongoDocumentUpdater<T, V> {
    default public void update(T key, DocumentMutator<V> mutator) throws IndexingException {
        Objects.requireNonNull(mutator);
        boolean completed = false;
        while (!completed) {
            Optional<V> old = this.getOld(key);
            Optional updated = (Optional)mutator.apply(old);
            boolean doWork = updated.isPresent();
            if (doWork) {
                if (!old.isPresent()) {
                    this.create(updated.get());
                } else {
                    this.update(old.get(), updated.get());
                }
            }
            completed = true;
        }
    }

    public Optional<V> getOld(T var1) throws IndexingException;

    public void create(V var1) throws IndexingException;

    public void update(V var1, V var2) throws IndexingException;

    public static interface DocumentMutator<V>
    extends Function<Optional<V>, Optional<V>> {
    }
}

