/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.temporal;

import com.mongodb.client.MongoCollection;
import java.util.regex.Matcher;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.indexing.TemporalInstantRfc3339;
import org.apache.rya.indexing.TemporalInterval;
import org.apache.rya.indexing.mongodb.IndexingMongoDBStorageStrategy;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TemporalMongoDBStorageStrategy
extends IndexingMongoDBStorageStrategy {
    public static final String INTERVAL_START = "start";
    public static final String INTERVAL_END = "end";
    public static final String INSTANT = "instant";

    public void createIndices(MongoCollection<Document> coll) {
        coll.createIndex((Bson)new Document(INTERVAL_START, (Object)1));
        coll.createIndex((Bson)new Document(INTERVAL_END, (Object)1));
        coll.createIndex((Bson)new Document(INSTANT, (Object)1));
    }

    public Document serialize(RyaStatement ryaStatement) {
        Document base = super.serialize(ryaStatement);
        Document time = this.getTimeValue(ryaStatement.getObject().getData());
        time.forEach((k, v) -> base.put(k, v));
        return base;
    }

    public Document getTimeValue(String timeData) {
        Matcher match = TemporalInstantRfc3339.PATTERN.matcher(timeData);
        Document doc = new Document();
        if (match.find()) {
            TemporalInterval date = TemporalInstantRfc3339.parseInterval(timeData);
            doc.append(INTERVAL_START, (Object)date.getHasBeginning().getAsDateTime().toDate());
            doc.append(INTERVAL_END, (Object)date.getHasEnd().getAsDateTime().toDate());
        } else {
            doc.append(INSTANT, (Object)TemporalInstantRfc3339.FORMATTER.parseDateTime(timeData).toDate());
        }
        return doc;
    }
}

