/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.temporal;

import com.google.common.annotations.VisibleForTesting;
import com.mongodb.client.MongoCollection;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.TemporalIndexer;
import org.apache.rya.indexing.TemporalInstant;
import org.apache.rya.indexing.TemporalInterval;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.mongodb.AbstractMongoIndexer;
import org.apache.rya.indexing.mongodb.temporal.TemporalMongoDBStorageStrategy;
import org.apache.rya.mongodb.document.operators.query.QueryBuilder;
import org.bson.Document;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class MongoTemporalIndexer
extends AbstractMongoIndexer<TemporalMongoDBStorageStrategy>
implements TemporalIndexer {
    private static final String COLLECTION_SUFFIX = "temporal";
    private static final Logger LOG = Logger.getLogger(MongoTemporalIndexer.class);

    public void init() {
        this.initCore();
        this.predicates = ConfigUtils.getTemporalPredicates((Configuration)this.conf);
        if (this.predicates.size() == 0) {
            LOG.debug((Object)"No predicates specified for temporal indexing.  During insertion, all statements will be attempted to be indexed into the temporal indexer.");
        }
        this.storageStrategy = new TemporalMongoDBStorageStrategy();
        ((TemporalMongoDBStorageStrategy)this.storageStrategy).createIndices((MongoCollection<Document>)this.collection);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantEqualsInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"instant").is((Object)queryInstant.getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantBeforeInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"instant").lessThan((Object)queryInstant.getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantAfterInstant(TemporalInstant queryInstant, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"instant").greaterThan((Object)queryInstant.getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantBeforeInterval(TemporalInterval givenInterval, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"instant").lessThan((Object)givenInterval.getHasBeginning().getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantAfterInterval(TemporalInterval givenInterval, StatementConstraints constraints) throws QueryEvaluationException {
        return this.queryInstantAfterInstant(givenInterval.getHasEnd(), constraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantInsideInterval(TemporalInterval givenInterval, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"instant").greaterThan((Object)givenInterval.getHasBeginning().getAsDateTime().toDate()).lessThan((Object)givenInterval.getHasEnd().getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantHasBeginningInterval(TemporalInterval queryInterval, StatementConstraints constraints) throws QueryEvaluationException {
        return this.queryInstantEqualsInstant(queryInterval.getHasBeginning(), constraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryInstantHasEndInterval(TemporalInterval queryInterval, StatementConstraints constraints) throws QueryEvaluationException {
        return this.queryInstantEqualsInstant(queryInterval.getHasEnd(), constraints);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalEquals(TemporalInterval query, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"start").is((Object)query.getHasBeginning().getAsDateTime().toDate()).and("end").is((Object)query.getHasEnd().getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalBefore(TemporalInterval query, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"end").lessThan((Object)query.getHasBeginning().getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryIntervalAfter(TemporalInterval query, StatementConstraints constraints) throws QueryEvaluationException {
        QueryBuilder qb = QueryBuilder.start((String)"start").greaterThan((Object)query.getHasEnd().getAsDateTime().toDate());
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public String getCollectionName() {
        return ConfigUtils.getTablePrefix((Configuration)this.conf) + COLLECTION_SUFFIX;
    }

    @VisibleForTesting
    public MongoCollection<Document> getCollection() {
        return this.collection;
    }
}

