/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.pcj;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.api.utils.CloseableIterator;
import org.apache.rya.api.utils.IteratorWrapper;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.external.tupleSet.ParsedQueryUtil;
import org.apache.rya.indexing.pcj.matching.PCJOptimizerUtilities;
import org.apache.rya.indexing.pcj.storage.PcjException;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjDocuments;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.rdftriplestore.evaluation.ExternalBatchingIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;

@DefaultAnnotation(value={NonNull.class})
public class MongoPcjQueryNode
extends ExternalTupleSet
implements ExternalBatchingIterator {
    private static final Logger log = Logger.getLogger(MongoPcjQueryNode.class);
    private final String pcjId;
    private final MongoPcjDocuments pcjDocs;

    public MongoPcjQueryNode(String sparql, String pcjId, MongoPcjDocuments pcjDocs) throws MalformedQueryException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)sparql) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pcjId) ? 1 : 0) != 0);
        this.pcjDocs = (MongoPcjDocuments)Preconditions.checkNotNull((Object)pcjDocs);
        this.pcjId = pcjId;
        SPARQLParser sp = new SPARQLParser();
        ParsedTupleQuery pq = (ParsedTupleQuery)sp.parseQuery(sparql, null);
        TupleExpr te = pq.getTupleExpr();
        Preconditions.checkArgument((boolean)PCJOptimizerUtilities.isPCJValid(te), (Object)"TupleExpr is an invalid PCJ.");
        Optional<Projection> projection = new ParsedQueryUtil().findProjection((ParsedQuery)pq);
        if (!projection.isPresent()) {
            throw new MalformedQueryException("SPARQL query '" + sparql + "' does not contain a Projection.");
        }
        this.setProjectionExpr((Projection)projection.get());
    }

    public MongoPcjQueryNode(Configuration conf, String pcjId) {
        Preconditions.checkNotNull((Object)conf);
        Preconditions.checkArgument((boolean)(conf instanceof StatefulMongoDBRdfConfiguration), (Object)("The configuration must be a StatefulMongoDBRdfConfiguration, found: " + conf.getClass().getSimpleName()));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pcjId) ? 1 : 0) != 0);
        StatefulMongoDBRdfConfiguration statefulConf = (StatefulMongoDBRdfConfiguration)conf;
        this.pcjDocs = new MongoPcjDocuments(statefulConf.getMongoClient(), statefulConf.getRyaInstanceName());
        this.pcjId = (String)Preconditions.checkNotNull((Object)pcjId);
    }

    public double cardinality() {
        double cardinality = 0.0;
        try {
            cardinality = this.pcjDocs.getPcjMetadata(this.pcjId).getCardinality();
        }
        catch (PcjException e) {
            log.error((Object)"The PCJ has not been created, so has no cardinality.", (Throwable)e);
        }
        return cardinality;
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindingset) throws QueryEvaluationException {
        return this.evaluate(Collections.singleton(bindingset));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Collection<BindingSet> bindingset) throws QueryEvaluationException {
        if (bindingset.isEmpty()) {
            return new IteratorWrapper(new HashSet().iterator());
        }
        final CloseableIterator iter = this.pcjDocs.getResults(this.pcjId, bindingset);
        return new CloseableIteration<BindingSet, QueryEvaluationException>(){

            public boolean hasNext() throws QueryEvaluationException {
                return iter.hasNext();
            }

            public BindingSet next() throws QueryEvaluationException {
                BindingSet bs = (BindingSet)iter.next();
                return bs;
            }

            public void remove() throws QueryEvaluationException {
                iter.remove();
            }

            public void close() throws QueryEvaluationException {
                try {
                    iter.close();
                }
                catch (Exception e) {
                    throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    @Override
    public String getSignature() {
        return "(Mongo PcjQueryNode) " + Joiner.on((String)", ").join((Iterable)super.getTupleExpr().getProjectionElemList().getElements()).replaceAll("\\s+", " ");
    }
}

