/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.pcj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mongodb.MongoClient;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.api.instance.RyaDetailsRepository;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.mongodb.pcj.MongoPcjQueryNode;
import org.apache.rya.indexing.pcj.matching.provider.AbstractPcjIndexSetProvider;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjDocuments;
import org.apache.rya.indexing.pcj.storage.mongo.MongoPcjStorage;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.instance.MongoRyaInstanceDetailsRepository;
import org.eclipse.rdf4j.query.MalformedQueryException;

public class MongoPcjIndexSetProvider
extends AbstractPcjIndexSetProvider {
    public MongoPcjIndexSetProvider(StatefulMongoDBRdfConfiguration conf) {
        super((Configuration)conf);
    }

    public MongoPcjIndexSetProvider(StatefulMongoDBRdfConfiguration conf, List<ExternalTupleSet> indices) {
        super((Configuration)conf, indices);
    }

    @Override
    protected List<ExternalTupleSet> getIndices() throws AbstractPcjIndexSetProvider.PcjIndexSetException {
        try {
            StatefulMongoDBRdfConfiguration mongoConf = (StatefulMongoDBRdfConfiguration)this.conf;
            MongoClient client = mongoConf.getMongoClient();
            MongoPcjDocuments pcjDocs = new MongoPcjDocuments(client, mongoConf.getRyaInstanceName());
            List documents = null;
            documents = mongoConf.getPcjTables();
            LinkedHashMap indexDocuments = Maps.newLinkedHashMap();
            MongoPcjStorage storage = new MongoPcjStorage(client, mongoConf.getRyaInstanceName());
            Object object = null;
            try {
                boolean docsProvided;
                boolean bl = docsProvided = documents != null && !documents.isEmpty();
                if (docsProvided) {
                    for (Object doc : documents) {
                        indexDocuments.put(doc, storage.getPcjMetadata((String)doc).getSparql());
                    }
                } else if (this.hasRyaDetails()) {
                    Object doc;
                    List ids = storage.listPcjs();
                    doc = ids.iterator();
                    while (doc.hasNext()) {
                        String pcjId = (String)doc.next();
                        indexDocuments.put(pcjId, storage.getPcjMetadata(pcjId).getSparql());
                    }
                } else {
                    documents = pcjDocs.listPcjDocuments();
                    for (String pcjId : documents) {
                        if (!pcjId.startsWith("INDEX")) continue;
                        indexDocuments.put(pcjId, pcjDocs.getPcjMetadata(pcjId).getSparql());
                    }
                }
            }
            catch (Throwable docsProvided) {
                object = docsProvided;
                throw docsProvided;
            }
            finally {
                if (storage != null) {
                    if (object != null) {
                        try {
                            storage.close();
                        }
                        catch (Throwable docsProvided) {
                            ((Throwable)object).addSuppressed(docsProvided);
                        }
                    } else {
                        storage.close();
                    }
                }
            }
            ArrayList index = Lists.newArrayList();
            if (indexDocuments.isEmpty()) {
                log.info((Object)"No Index found");
            } else {
                for (String pcjID : indexDocuments.keySet()) {
                    String indexSparqlString = (String)indexDocuments.get(pcjID);
                    index.add(new MongoPcjQueryNode(indexSparqlString, pcjID, pcjDocs));
                }
            }
            return index;
        }
        catch (PrecomputedJoinStorage.PCJStorageException | MalformedQueryException e) {
            throw new AbstractPcjIndexSetProvider.PcjIndexSetException(this, "Failed to get indicies for this PCJ index.", e);
        }
    }

    private boolean hasRyaDetails() {
        StatefulMongoDBRdfConfiguration mongoConf = (StatefulMongoDBRdfConfiguration)this.conf;
        MongoRyaInstanceDetailsRepository detailsRepo = new MongoRyaInstanceDetailsRepository(mongoConf.getMongoClient(), mongoConf.getRyaInstanceName());
        try {
            detailsRepo.getRyaInstanceDetails();
            return true;
        }
        catch (RyaDetailsRepository.RyaDetailsRepositoryException e) {
            return false;
        }
    }
}

