/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb.freetext;

import com.mongodb.client.MongoCollection;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.indexing.FreeTextIndexer;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.mongodb.AbstractMongoIndexer;
import org.apache.rya.indexing.mongodb.freetext.TextMongoDBStorageStrategy;
import org.apache.rya.mongodb.document.operators.query.QueryBuilder;
import org.bson.Document;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public class MongoFreeTextIndexer
extends AbstractMongoIndexer<TextMongoDBStorageStrategy>
implements FreeTextIndexer {
    private static final String COLLECTION_SUFFIX = "freetext";
    private static final Logger logger = Logger.getLogger(MongoFreeTextIndexer.class);

    public void init() {
        this.initCore();
        this.predicates = ConfigUtils.getFreeTextPredicates((Configuration)this.conf);
        if (this.predicates.size() == 0) {
            logger.debug((Object)"No predicates specified for freetext indexing.  During insertion, all statements will be attempted to be indexed into the freetext indexer.");
        }
        this.storageStrategy = new TextMongoDBStorageStrategy();
        ((TextMongoDBStorageStrategy)this.storageStrategy).createIndices((MongoCollection<Document>)this.collection);
    }

    @Override
    public CloseableIteration<Statement, QueryEvaluationException> queryText(String query, StatementConstraints constraints) throws IOException {
        QueryBuilder qb = QueryBuilder.start().text(query);
        return this.withConstraints(constraints, qb.get());
    }

    @Override
    public String getCollectionName() {
        return ConfigUtils.getTablePrefix((Configuration)this.conf) + COLLECTION_SUFFIX;
    }
}

