/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb;

import com.google.common.base.Preconditions;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.mongodb.AbstractMongoDBRdfConfigurationBuilder;
import org.apache.rya.mongodb.MongoDBRdfConfiguration;

public class MongoIndexingConfiguration
extends MongoDBRdfConfiguration {
    private MongoIndexingConfiguration() {
    }

    private MongoIndexingConfiguration(Configuration conf) {
        super(conf);
    }

    public static MongoDBIndexingConfigBuilder builder() {
        return new MongoDBIndexingConfigBuilder();
    }

    public static MongoIndexingConfiguration fromProperties(Properties props) {
        return MongoDBIndexingConfigBuilder.fromProperties(props);
    }

    public void setUseEntity(boolean useEntity) {
        this.setBoolean("sc.use_entity", useEntity);
    }

    public boolean getUseEntity() {
        return this.getBoolean("sc.use_entity", false);
    }

    public void setUseTemporal(boolean useTemporal) {
        this.setBoolean("sc.use_temporal", useTemporal);
    }

    public boolean getUseTemporal() {
        return this.getBoolean("sc.use_temporal", false);
    }

    public boolean getUseFreetext() {
        return this.getBoolean("sc.use_freetext", false);
    }

    public void setUseFreetext(boolean useFreetext) {
        this.setBoolean("sc.use_freetext", useFreetext);
    }

    public void setMongoFreeTextPredicates(String[] predicates) {
        Preconditions.checkNotNull((Object)predicates, (Object)"Freetext predicates cannot be null.");
        this.setStrings("sc.freetext.predicates", predicates);
    }

    public String[] getMongoFreeTextPredicates() {
        return this.getStrings("sc.freetext.predicates");
    }

    public void setMongoTemporalPredicates(String[] predicates) {
        Preconditions.checkNotNull((Object)predicates, (Object)"Freetext predicates cannot be null.");
        this.setStrings("sc.temporal.predicates", predicates);
    }

    public String[] getMongoTemporalPredicates() {
        return this.getStrings("sc.temporal.predicates");
    }

    public static class MongoDBIndexingConfigBuilder
    extends AbstractMongoDBRdfConfigurationBuilder<MongoDBIndexingConfigBuilder, MongoIndexingConfiguration> {
        private boolean useFreetext = false;
        private boolean useTemporal = false;
        private boolean useEntity = false;
        private String[] freetextPredicates;
        private String[] temporalPredicates;
        private static final String USE_FREETEXT = "use.freetext";
        private static final String USE_TEMPORAL = "use.temporal";
        private static final String USE_ENTITY = "use.entity";
        private static final String TEMPORAL_PREDICATES = "temporal.predicates";
        private static final String FREETEXT_PREDICATES = "freetext.predicates";

        public static MongoIndexingConfiguration fromProperties(Properties props) {
            try {
                MongoDBIndexingConfigBuilder builder = ((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)((MongoDBIndexingConfigBuilder)new MongoDBIndexingConfigBuilder().setAuths(props.getProperty("mongo.auths", ""))).setRyaPrefix(props.getProperty("mongo.rya.prefix", "rya_"))).setVisibilities(props.getProperty("mongo.visibilities", ""))).setUseInference(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty("use.inference", "false")))).setDisplayQueryPlan(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty("use.display.plan", "true")))).setMongoUser(props.getProperty("mongo.user"))).setMongoPassword(props.getProperty("mongo.password"))).setMongoCollectionPrefix(props.getProperty("mongo.collection.prefix", "rya_"))).setMongoDBName(props.getProperty("mongo.db.name", "rya_triples"))).setMongoHost(props.getProperty("mongo.host", "localhost"))).setMongoPort(props.getProperty("mongo.port", "27017"))).setUseMockMongo(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty("use.mock", "false")))).setUseMongoFreetextIndex(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_FREETEXT, "false"))).setUseMongoTemporalIndex(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_TEMPORAL, "false"))).setUseMongoEntityIndex(MongoDBIndexingConfigBuilder.getBoolean((String)props.getProperty(USE_ENTITY, "false"))).setMongoFreeTextPredicates(StringUtils.split((String)props.getProperty(FREETEXT_PREDICATES), (String)",")).setMongoTemporalPredicates(StringUtils.split((String)props.getProperty(TEMPORAL_PREDICATES), (String)","));
                return builder.build();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public MongoDBIndexingConfigBuilder setUseMongoFreetextIndex(boolean useFreeText) {
            this.useFreetext = useFreeText;
            return this;
        }

        public MongoDBIndexingConfigBuilder setUseMongoTemporalIndex(boolean useTemporal) {
            this.useTemporal = useTemporal;
            return this;
        }

        public MongoDBIndexingConfigBuilder setUseMongoEntityIndex(boolean useEntity) {
            this.useEntity = useEntity;
            return this;
        }

        public MongoDBIndexingConfigBuilder setMongoFreeTextPredicates(String ... predicates) {
            this.freetextPredicates = predicates;
            return this;
        }

        public MongoDBIndexingConfigBuilder setMongoTemporalPredicates(String ... predicates) {
            this.temporalPredicates = predicates;
            return this;
        }

        public MongoIndexingConfiguration build() {
            MongoIndexingConfiguration conf = this.getConf((MongoIndexingConfiguration)super.build());
            return conf;
        }

        private MongoIndexingConfiguration getConf(MongoIndexingConfiguration conf) {
            if (this.useFreetext) {
                conf.setUseFreetext(this.useFreetext);
                if (this.freetextPredicates != null) {
                    conf.setMongoFreeTextPredicates(this.freetextPredicates);
                }
            }
            if (this.useTemporal) {
                conf.setUseTemporal(this.useTemporal);
                if (this.temporalPredicates != null) {
                    conf.setMongoTemporalPredicates(this.temporalPredicates);
                }
            }
            conf.setUseEntity(this.useEntity);
            return conf;
        }

        protected MongoDBIndexingConfigBuilder confBuilder() {
            return this;
        }

        protected MongoIndexingConfiguration createConf() {
            return new MongoIndexingConfiguration();
        }
    }
}

