/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.model.TypedEntity;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.indexing.entity.storage.mongo.MongoEntityStorage;
import org.apache.rya.indexing.mongodb.update.RyaObjectStorage;
import org.apache.rya.indexing.smarturi.SmartUriAdapter;
import org.apache.rya.indexing.smarturi.SmartUriException;
import org.apache.rya.indexing.smarturi.SmartUriStorage;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;

public class MongoDbSmartUri
implements SmartUriStorage {
    private boolean isInit = false;
    private final StatefulMongoDBRdfConfiguration conf;
    private MongoClient mongoClient = null;
    private EntityStorage entityStorage;

    public MongoDbSmartUri(StatefulMongoDBRdfConfiguration conf) {
        this.conf = (StatefulMongoDBRdfConfiguration)Preconditions.checkNotNull((Object)conf);
    }

    @Override
    public void storeEntity(RyaIRI subject, Map<IRI, Value> map) throws SmartUriException {
        this.checkInit();
        IRI uri = SmartUriAdapter.serializeUri(subject, map);
        Entity entity = SmartUriAdapter.deserializeUriEntity(uri);
        try {
            this.entityStorage.create(entity);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new SmartUriException("Failed to create entity storage", e);
        }
    }

    @Override
    public void storeEntity(Entity entity) throws SmartUriException {
        this.checkInit();
        try {
            this.entityStorage.create(entity);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new SmartUriException("Failed to create entity storage", e);
        }
    }

    @Override
    public void updateEntity(Entity oldEntity, Entity updatedEntity) throws SmartUriException {
        this.checkInit();
        try {
            this.entityStorage.update(oldEntity, updatedEntity);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new SmartUriException("Failed to update entity", e);
        }
    }

    @Override
    public Entity queryEntity(RyaIRI subject) throws SmartUriException {
        this.checkInit();
        try {
            Optional resultEntity = this.entityStorage.get(subject);
            return (Entity)resultEntity.get();
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new SmartUriException("Failed to query entity storage", e);
        }
    }

    @Override
    public ConvertingCursor<TypedEntity> queryEntity(Type type, Map<IRI, Value> map) throws SmartUriException {
        this.checkInit();
        try {
            Set<Property> properties = SmartUriAdapter.mapToProperties(map);
            ConvertingCursor<TypedEntity> cursor = this.entityStorage.search(Optional.empty(), type, properties);
            return cursor;
        }
        catch (EntityStorage.EntityStorageException e) {
            throw new SmartUriException("Failed to query entity storage", e);
        }
    }

    private void checkInit() throws SmartUriException {
        if (!this.isInit) {
            try {
                this.setupClient(this.conf);
            }
            catch (MongoException | UnknownHostException | EntityStorage.EntityStorageException e) {
                throw new SmartUriException("Failed to setup MongoDB client", e);
            }
        }
    }

    private void setupClient(StatefulMongoDBRdfConfiguration conf) throws UnknownHostException, MongoException, EntityStorage.EntityStorageException {
        this.mongoClient = conf.getMongoClient();
        this.entityStorage = new MongoEntityStorage(this.mongoClient, conf.getRyaInstanceName());
        this.isInit = true;
    }

    public EntityStorage getEntityStorage() {
        return this.entityStorage;
    }
}

