/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb;

import java.util.Set;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.mongodb.dao.SimpleMongoDBStorageStrategy;
import org.apache.rya.mongodb.document.operators.query.QueryBuilder;
import org.bson.Document;
import org.eclipse.rdf4j.model.IRI;

public class IndexingMongoDBStorageStrategy
extends SimpleMongoDBStorageStrategy {
    public Document getQuery(StatementConstraints contraints) {
        QueryBuilder queryBuilder = QueryBuilder.start();
        if (contraints.hasSubject()) {
            queryBuilder.and(new Document[]{new Document("subject", (Object)contraints.getSubject().toString())});
        }
        if (contraints.hasPredicates()) {
            Set<IRI> predicates = contraints.getPredicates();
            if (predicates.size() > 1) {
                for (IRI pred : predicates) {
                    Document currentPred = new Document("predicate", (Object)pred.toString());
                    queryBuilder.or(new Document[]{currentPred});
                }
            } else if (!predicates.isEmpty()) {
                queryBuilder.and(new Document[]{new Document("predicate", (Object)predicates.iterator().next().toString())});
            }
        }
        if (contraints.hasContext()) {
            queryBuilder.and(new Document[]{new Document("context", (Object)contraints.getContext().toString())});
        }
        return queryBuilder.get();
    }
}

