/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.mongodb;

import com.google.common.base.Preconditions;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.resolver.RyaToRdfConversions;
import org.apache.rya.indexing.StatementConstraints;
import org.apache.rya.indexing.mongodb.IndexingMongoDBStorageStrategy;
import org.apache.rya.mongodb.MongoDBRyaDAO;
import org.apache.rya.mongodb.MongoSecondaryIndex;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.apache.rya.mongodb.batch.MongoDbBatchWriter;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterConfig;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterException;
import org.apache.rya.mongodb.batch.MongoDbBatchWriterUtils;
import org.apache.rya.mongodb.batch.collection.CollectionType;
import org.apache.rya.mongodb.batch.collection.MongoCollectionType;
import org.apache.rya.mongodb.document.operators.query.QueryBuilder;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.QueryEvaluationException;

public abstract class AbstractMongoIndexer<T extends IndexingMongoDBStorageStrategy>
implements MongoSecondaryIndex {
    private static final Logger LOG = Logger.getLogger(AbstractMongoIndexer.class);
    private boolean flushEachUpdate = true;
    protected StatefulMongoDBRdfConfiguration conf;
    protected MongoDBRyaDAO dao;
    protected MongoClient mongoClient;
    protected String dbName;
    protected MongoDatabase db;
    protected MongoCollection<Document> collection;
    protected Set<IRI> predicates;
    protected T storageStrategy;
    private MongoDbBatchWriter<Document> mongoDbBatchWriter;

    protected void initCore() {
        this.dbName = this.conf.getMongoDBName();
        this.mongoClient = this.conf.getMongoClient();
        this.db = this.mongoClient.getDatabase(this.dbName);
        String collectionName = this.conf.get("mongo.db.collectionprefix", "rya") + this.getCollectionName();
        this.collection = this.db.getCollection(collectionName);
        this.flushEachUpdate = this.conf.flushEachUpdate();
        MongoDbBatchWriterConfig mongoDbBatchWriterConfig = MongoDbBatchWriterUtils.getMongoDbBatchWriterConfig((Configuration)this.conf);
        this.mongoDbBatchWriter = new MongoDbBatchWriter((CollectionType)new MongoCollectionType(this.collection), mongoDbBatchWriterConfig);
        try {
            this.mongoDbBatchWriter.start();
        }
        catch (MongoDbBatchWriterException e) {
            LOG.error((Object)"Error start MongoDB batch writer", (Throwable)e);
        }
    }

    public void setConf(Configuration conf) {
        Preconditions.checkState((boolean)(conf instanceof StatefulMongoDBRdfConfiguration), (Object)("The provided Configuration must be a StatefulMongoDBRdfConfiguration, but it was " + conf.getClass().getName()));
        this.conf = (StatefulMongoDBRdfConfiguration)conf;
    }

    public void close() throws IOException {
        this.flush();
        try {
            this.mongoDbBatchWriter.shutdown();
        }
        catch (MongoDbBatchWriterException e) {
            throw new IOException("Error shutting down MongoDB batch writer", e);
        }
    }

    public void flush() throws IOException {
        try {
            this.mongoDbBatchWriter.flush();
        }
        catch (MongoDbBatchWriterException e) {
            throw new IOException("Error flushing batch writer", e);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getTableName() {
        return this.dbName;
    }

    public Set<IRI> getIndexablePredicates() {
        return this.predicates;
    }

    public void deleteStatement(RyaStatement stmt) throws IOException {
        Document obj = this.storageStrategy.getQuery(stmt);
        this.collection.deleteOne((Bson)obj);
    }

    public void storeStatements(Collection<RyaStatement> ryaStatements) throws IOException {
        for (RyaStatement ryaStatement : ryaStatements) {
            this.storeStatement(ryaStatement, false);
        }
        if (this.flushEachUpdate) {
            this.flush();
        }
    }

    public void storeStatement(RyaStatement ryaStatement) throws IOException {
        this.storeStatement(ryaStatement, this.flushEachUpdate);
    }

    private void storeStatement(RyaStatement ryaStatement, boolean flush) throws IOException {
        Document obj = this.prepareStatementForStorage(ryaStatement);
        try {
            this.mongoDbBatchWriter.addObjectToQueue((Object)obj);
            if (flush) {
                this.flush();
            }
        }
        catch (MongoDbBatchWriterException e) {
            throw new IOException("Error storing statement", e);
        }
    }

    private Document prepareStatementForStorage(RyaStatement ryaStatement) {
        try {
            boolean isValidPredicate;
            Statement statement = RyaToRdfConversions.convertStatement((RyaStatement)ryaStatement);
            boolean bl = isValidPredicate = this.predicates.isEmpty() || this.predicates.contains(statement.getPredicate());
            if (isValidPredicate && statement.getObject() instanceof Literal) {
                Document obj = this.storageStrategy.serialize(ryaStatement);
                return obj;
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Unable to parse the statement: " + ryaStatement.toString()), (Throwable)e);
        }
        return null;
    }

    public void dropGraph(RyaIRI ... graphs) {
        throw new UnsupportedOperationException();
    }

    protected CloseableIteration<Statement, QueryEvaluationException> withConstraints(StatementConstraints constraints, Document preConstraints) {
        Document doc = QueryBuilder.start().and(new Document[]{preConstraints}).and(new Document[]{((IndexingMongoDBStorageStrategy)((Object)this.storageStrategy)).getQuery(constraints)}).get();
        return this.closableIterationFromCursor(doc);
    }

    private CloseableIteration<Statement, QueryEvaluationException> closableIterationFromCursor(Document doc) {
        final MongoCursor cursor = this.collection.find((Bson)doc).iterator();
        return new CloseableIteration<Statement, QueryEvaluationException>(){

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public Statement next() throws QueryEvaluationException {
                Document doc = (Document)cursor.next();
                return RyaToRdfConversions.convertStatement((RyaStatement)AbstractMongoIndexer.this.storageStrategy.deserializeDocument(doc));
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove not implemented");
            }

            public void close() throws QueryEvaluationException {
                cursor.close();
            }
        };
    }

    public abstract String getCollectionName();
}

