/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.tupleSet;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.api.domain.VarNameUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public abstract class ExternalTupleSet
extends ExternalSet {
    public static final String VAR_ORDER_DELIM = ";";
    @Deprecated
    public static final String CONST_PREFIX = "_const_";
    public static final String VALUE_DELIM = "\u0000";
    private Projection tupleExpr;
    private Map<String, String> tableVarMap = Maps.newHashMap();
    private Map<String, Set<String>> supportedVarOrders = Maps.newHashMap();
    private Map<String, Value> valMap;

    public ExternalTupleSet() {
    }

    public ExternalTupleSet(Projection tupleExpr) {
        Preconditions.checkNotNull((Object)tupleExpr);
        this.tupleExpr = tupleExpr;
        this.valMap = this.getValMap();
        this.updateTableVarMap((TupleExpr)tupleExpr, (TupleExpr)tupleExpr);
    }

    public abstract CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet var1) throws QueryEvaluationException;

    public Set<String> getBindingNames() {
        return this.tupleExpr.getBindingNames();
    }

    public Set<String> getAssuredBindingNames() {
        return this.tupleExpr.getAssuredBindingNames();
    }

    public String getSignature() {
        return "(External Projection) " + Joiner.on((String)", ").join((Iterable)this.tupleExpr.getProjectionElemList().getElements()).replaceAll("\\s+", " ");
    }

    public Projection getTupleExpr() {
        return this.tupleExpr;
    }

    public void setProjectionExpr(Projection tupleExpr) {
        Preconditions.checkNotNull((Object)tupleExpr);
        if (this.tupleExpr == null) {
            this.updateTableVarMap((TupleExpr)tupleExpr, (TupleExpr)tupleExpr);
        } else {
            this.updateTableVarMap((TupleExpr)tupleExpr, (TupleExpr)this.tupleExpr);
        }
        this.tupleExpr = tupleExpr;
        this.valMap = this.getValMap();
        if (this.supportedVarOrders.size() != 0) {
            this.updateSupportedVarOrderMap();
        }
    }

    public void setTableVarMap(Map<String, String> vars) {
        Preconditions.checkNotNull(vars);
        this.tableVarMap = vars;
    }

    public Map<String, String> getTableVarMap() {
        return this.tableVarMap;
    }

    public void setSupportedVariableOrderMap(Map<String, Set<String>> varOrders) {
        Preconditions.checkNotNull(varOrders);
        this.supportedVarOrders = varOrders;
    }

    public void setSupportedVariableOrderMap(List<String> varOrders) {
        Preconditions.checkNotNull(varOrders);
        this.supportedVarOrders = this.createSupportedVarOrderMap(varOrders);
    }

    public Map<String, Set<String>> getSupportedVariableOrderMap() {
        return this.supportedVarOrders;
    }

    public Map<String, Value> getConstantValueMap() {
        return this.valMap;
    }

    public ExternalSet clone() {
        ExternalTupleSet clone = (ExternalTupleSet)super.clone();
        clone.setProjectionExpr(this.tupleExpr.clone());
        clone.tableVarMap = Maps.newHashMap();
        for (String s : this.tableVarMap.keySet()) {
            clone.tableVarMap.put(s, this.tableVarMap.get(s));
        }
        clone.supportedVarOrders = Maps.newHashMap();
        for (String s : this.supportedVarOrders.keySet()) {
            clone.supportedVarOrders.put(s, this.supportedVarOrders.get(s));
        }
        return clone;
    }

    public Map<String, Set<String>> getSupportedVariableOrders() {
        return this.supportedVarOrders;
    }

    public boolean supportsBindingSet(Set<String> bindingNames) {
        Collection<Set<String>> values = this.supportedVarOrders.values();
        HashSet bNames = Sets.newHashSet();
        HashSet bNamesWithConstants = Sets.newHashSet();
        for (String s : this.getTupleExpr().getBindingNames()) {
            if (bindingNames.contains(s)) {
                bNames.add(s);
                bNamesWithConstants.add(s);
                continue;
            }
            if (!VarNameUtils.isConstant((String)s)) continue;
            bNamesWithConstants.add(s);
        }
        return values.contains(bNames) || values.contains(bNamesWithConstants);
    }

    private void updateTableVarMap(TupleExpr newTuple, TupleExpr oldTuple) {
        ArrayList replacementVars = Lists.newArrayList((Iterable)newTuple.getBindingNames());
        ArrayList tableVars = Lists.newArrayList((Iterable)oldTuple.getBindingNames());
        HashMap tableMap = Maps.newHashMap();
        for (int i = 0; i < tableVars.size(); ++i) {
            tableMap.put(replacementVars.get(i), tableVars.get(i));
        }
        this.setTableVarMap(tableMap);
    }

    private void updateSupportedVarOrderMap() {
        Preconditions.checkArgument((this.supportedVarOrders.size() != 0 ? 1 : 0) != 0);
        HashMap newSupportedOrders = Maps.newHashMap();
        BiMap biMap = HashBiMap.create(this.tableVarMap).inverse();
        Set<String> temp = null;
        Set<String> keys = this.supportedVarOrders.keySet();
        for (String s : keys) {
            temp = this.supportedVarOrders.get(s);
            HashSet newSet = Sets.newHashSet();
            for (String t : temp) {
                newSet.add(biMap.get((Object)t));
            }
            String[] tempStrings = s.split(VAR_ORDER_DELIM);
            String v = "";
            for (String u : tempStrings) {
                v = v.length() == 0 ? v + (String)biMap.get((Object)u) : v + VAR_ORDER_DELIM + (String)biMap.get((Object)u);
            }
            newSupportedOrders.put(v, newSet);
        }
        this.supportedVarOrders = newSupportedOrders;
    }

    private Map<String, Set<String>> createSupportedVarOrderMap(List<String> orders) {
        HashMap supportedVars = Maps.newHashMap();
        for (String t : orders) {
            String[] tempOrder = t.split(VAR_ORDER_DELIM);
            HashSet varSet = Sets.newHashSet();
            String u = "";
            for (String s : tempOrder) {
                u = u.length() == 0 ? s : u + VAR_ORDER_DELIM + s;
                varSet.add(s);
                supportedVars.put(u, new HashSet(varSet));
            }
        }
        return supportedVars;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExternalTupleSet)) {
            return false;
        }
        ExternalTupleSet arg = (ExternalTupleSet)((Object)other);
        return this.getTupleExpr().equals((Object)arg.getTupleExpr());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.tupleExpr.hashCode();
        return result;
    }

    private Map<String, Value> getValMap() {
        ValueMapVisitor valMapVis = new ValueMapVisitor();
        this.tupleExpr.visit((QueryModelVisitor)valMapVis);
        return valMapVis.getValMap();
    }

    private class ValueMapVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        Map<String, Value> valMap = Maps.newHashMap();

        private ValueMapVisitor() {
        }

        public Map<String, Value> getValMap() {
            return this.valMap;
        }

        public void meet(Var node) {
            if (VarNameUtils.isConstant((String)node.getName())) {
                this.valMap.put(node.getName(), node.getValue());
            }
        }
    }
}

