/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.tupleSet;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.rya.accumulo.pcj.iterators.BindingSetHashJoinIterator;
import org.apache.rya.accumulo.pcj.iterators.IteratorCombiner;
import org.apache.rya.accumulo.pcj.iterators.PCJKeyToCrossProductBindingSetIterator;
import org.apache.rya.accumulo.pcj.iterators.PCJKeyToJoinBindingSetIterator;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.api.utils.IteratorWrapper;
import org.apache.rya.indexing.accumulo.ConfigUtils;
import org.apache.rya.indexing.external.tupleSet.ExternalTupleSet;
import org.apache.rya.indexing.external.tupleSet.ParsedQueryUtil;
import org.apache.rya.indexing.pcj.matching.PCJOptimizerUtilities;
import org.apache.rya.indexing.pcj.storage.PcjException;
import org.apache.rya.indexing.pcj.storage.PcjMetadata;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjSerializer;
import org.apache.rya.indexing.pcj.storage.accumulo.BindingSetConverter;
import org.apache.rya.indexing.pcj.storage.accumulo.PcjTables;
import org.apache.rya.indexing.pcj.storage.accumulo.VariableOrder;
import org.apache.rya.rdftriplestore.evaluation.ExternalBatchingIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLParser;
import org.eclipse.rdf4j.sail.SailException;

public class AccumuloIndexSet
extends ExternalTupleSet
implements ExternalBatchingIterator {
    private final Connector accCon;
    private final String tablename;
    private List<String> varOrder = null;
    private final PcjTables pcj = new PcjTables();
    private final Authorizations auths;

    @Override
    public Map<String, Set<String>> getSupportedVariableOrders() {
        return this.getSupportedVariableOrderMap();
    }

    @Override
    public String getSignature() {
        return "AccumuloIndexSet(" + this.tablename + ") : " + Joiner.on((String)", ").join((Iterable)this.getTupleExpr().getBindingNames());
    }

    public AccumuloIndexSet(String sparql, Configuration conf, String tablename) throws MalformedQueryException, SailException, QueryEvaluationException, TableNotFoundException, AccumuloException, AccumuloSecurityException, PrecomputedJoinStorage.PCJStorageException {
        this.tablename = tablename;
        this.accCon = ConfigUtils.getConnector(conf);
        this.auths = this.getAuthorizations(conf);
        SPARQLParser sp = new SPARQLParser();
        ParsedTupleQuery pq = (ParsedTupleQuery)sp.parseQuery(sparql, null);
        TupleExpr te = pq.getTupleExpr();
        Preconditions.checkArgument((boolean)PCJOptimizerUtilities.isPCJValid(te), (Object)"TupleExpr is an invalid PCJ.");
        Optional<Projection> projection = new ParsedQueryUtil().findProjection((ParsedQuery)pq);
        if (!projection.isPresent()) {
            throw new MalformedQueryException("SPARQL query '" + sparql + "' does not contain a Projection.");
        }
        this.setProjectionExpr((Projection)projection.get());
        ImmutableSet orders = null;
        orders = this.pcj.getPcjMetadata(this.accCon, tablename).getVarOrders();
        this.varOrder = Lists.newArrayList();
        for (VariableOrder var : orders) {
            this.varOrder.add(var.toString());
        }
        this.setLocalityGroups(tablename, this.accCon, this.varOrder);
        this.setSupportedVariableOrderMap(this.varOrder);
    }

    public AccumuloIndexSet(Configuration conf, String tablename) throws MalformedQueryException, SailException, QueryEvaluationException, TableNotFoundException, AccumuloException, AccumuloSecurityException, PrecomputedJoinStorage.PCJStorageException {
        this.tablename = tablename;
        this.accCon = ConfigUtils.getConnector(conf);
        this.auths = this.getAuthorizations(conf);
        PcjMetadata meta = this.pcj.getPcjMetadata(this.accCon, tablename);
        SPARQLParser sp = new SPARQLParser();
        ParsedTupleQuery pq = (ParsedTupleQuery)sp.parseQuery(meta.getSparql(), null);
        this.setProjectionExpr((Projection)pq.getTupleExpr());
        ImmutableSet orders = meta.getVarOrders();
        this.varOrder = Lists.newArrayList();
        for (VariableOrder var : orders) {
            this.varOrder.add(var.toString());
        }
        this.setLocalityGroups(tablename, this.accCon, this.varOrder);
        this.setSupportedVariableOrderMap(this.varOrder);
    }

    private Authorizations getAuthorizations(Configuration conf) {
        String authString = conf.get("query.auth", "");
        if (authString.isEmpty()) {
            return new Authorizations();
        }
        return new Authorizations(authString.split(","));
    }

    public double cardinality() {
        double cardinality = 0.0;
        try {
            cardinality = this.pcj.getPcjMetadata(this.accCon, this.tablename).getCardinality();
        }
        catch (PcjException e) {
            e.printStackTrace();
        }
        return cardinality;
    }

    private void setLocalityGroups(String tableName, Connector conn, List<String> groups) {
        HashMap localityGroups = new HashMap();
        for (int i = 0; i < groups.size(); ++i) {
            HashSet<Text> tempColumn = new HashSet<Text>();
            tempColumn.add(new Text(groups.get(i)));
            String groupName = groups.get(i).replace("\u0000", "");
            localityGroups.put(groupName, tempColumn);
        }
        try {
            conn.tableOperations().setLocalityGroups(tableName, localityGroups);
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindingset) throws QueryEvaluationException {
        return this.evaluate(Collections.singleton(bindingset));
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Collection<BindingSet> bindingset) throws QueryEvaluationException {
        Range EMPTY_RANGE;
        if (bindingset.isEmpty()) {
            return new IteratorWrapper(new HashSet().iterator());
        }
        ArrayList<BindingSet> crossProductBs = new ArrayList<BindingSet>();
        HashMap<String, Value> constantConstraints = new HashMap<String, Value>();
        HashSet<Range> hashJoinRanges = new HashSet<Range>();
        Range crossProductRange = EMPTY_RANGE = new Range((CharSequence)"", true, (CharSequence)"~", false);
        String localityGroupOrder = this.varOrder.get(0);
        int maxPrefixLen = Integer.MIN_VALUE;
        int prefixLen = 0;
        int oldPrefixLen = 0;
        HashMultimap bindingSetHashMap = HashMultimap.create();
        BindingSetHashJoinIterator.HashJoinType joinType = BindingSetHashJoinIterator.HashJoinType.CONSTANT_JOIN_VAR;
        Sets.SetView unAssuredVariables = Sets.difference((Set)this.getTupleExpr().getBindingNames(), (Set)this.getTupleExpr().getAssuredBindingNames());
        boolean useColumnScan = false;
        boolean isCrossProd = false;
        boolean containsConstantConstraints = false;
        BindingSet constants = this.getConstantConstraints();
        containsConstantConstraints = constants.size() > 0;
        try {
            Scanner scanner;
            for (BindingSet bs : bindingset) {
                if (bindingset.size() == 1 && bs.size() == 0) {
                    useColumnScan = true;
                }
                QueryBindingSet commonVars = new QueryBindingSet();
                for (String b : this.getTupleExpr().getAssuredBindingNames()) {
                    Binding v = bs.getBinding(b);
                    if (v == null) continue;
                    commonVars.addBinding(v);
                }
                if (commonVars.size() == 0 && bs.size() != 0) {
                    crossProductBs.add(bs);
                    isCrossProd = true;
                }
                BindingSetVariableOrder varOrder = this.getVarOrder(commonVars.getBindingNames(), constants.getBindingNames());
                commonVars.addAll(constants);
                if (commonVars.size() > varOrder.varOrderLen) {
                    Map<String, Value> valMap = this.getConstantValueMap();
                    for (String s : new HashSet<String>(varOrder.unusedVars)) {
                        if (valMap.containsKey(s) && !constantConstraints.containsKey(s)) {
                            constantConstraints.put(s, valMap.get(s));
                        }
                        commonVars.removeBinding(s);
                    }
                }
                if (containsConstantConstraints && (useColumnScan || isCrossProd)) {
                    if (crossProductRange == EMPTY_RANGE) {
                        crossProductRange = this.getRange(varOrder.varOrder, (BindingSet)commonVars);
                        localityGroupOrder = this.prefixToOrder(varOrder.varOrder);
                    }
                } else if (!useColumnScan && !isCrossProd) {
                    hashJoinRanges.add(this.getRange(varOrder.varOrder, (BindingSet)commonVars));
                    prefixLen = varOrder.varOrderLen;
                    if (oldPrefixLen == 0) {
                        oldPrefixLen = prefixLen;
                    } else {
                        if (oldPrefixLen != prefixLen && joinType == BindingSetHashJoinIterator.HashJoinType.CONSTANT_JOIN_VAR) {
                            joinType = BindingSetHashJoinIterator.HashJoinType.VARIABLE_JOIN_VAR;
                        }
                        oldPrefixLen = prefixLen;
                    }
                    if (prefixLen > maxPrefixLen) {
                        maxPrefixLen = prefixLen;
                    }
                    String key = this.getHashJoinKey(varOrder.varOrder, (BindingSet)commonVars);
                    bindingSetHashMap.put((Object)key, (Object)bs);
                }
                isCrossProd = false;
            }
            if ((useColumnScan || crossProductBs.size() > 0) && bindingSetHashMap.size() == 0) {
                scanner = this.accCon.createScanner(this.tablename, this.auths);
                scanner.setRange(crossProductRange);
                scanner.fetchColumnFamily(new Text(localityGroupOrder));
                return new PCJKeyToCrossProductBindingSetIterator(scanner, crossProductBs, constantConstraints, (Set<String>)unAssuredVariables, this.getTableVarMap());
            }
            if ((useColumnScan || crossProductBs.size() > 0) && bindingSetHashMap.size() > 0) {
                ArrayList<CloseableIteration<BindingSet, QueryEvaluationException>> iteratorList = new ArrayList<CloseableIteration<BindingSet, QueryEvaluationException>>();
                Scanner scanner1 = this.accCon.createScanner(this.tablename, this.auths);
                scanner1.setRange(crossProductRange);
                scanner1.fetchColumnFamily(new Text(localityGroupOrder));
                iteratorList.add(new PCJKeyToCrossProductBindingSetIterator(scanner1, crossProductBs, constantConstraints, (Set<String>)unAssuredVariables, this.getTableVarMap()));
                BatchScanner scanner2 = this.accCon.createBatchScanner(this.tablename, this.auths, 10);
                scanner2.setRanges(hashJoinRanges);
                PCJKeyToJoinBindingSetIterator iterator = new PCJKeyToJoinBindingSetIterator(scanner2, this.getTableVarMap(), maxPrefixLen);
                iteratorList.add(new BindingSetHashJoinIterator((Multimap<String, BindingSet>)bindingSetHashMap, iterator, (Set<String>)unAssuredVariables, joinType));
                return new IteratorCombiner(iteratorList);
            }
            scanner = this.accCon.createBatchScanner(this.tablename, this.auths, 10);
            scanner.setRanges(hashJoinRanges);
            PCJKeyToJoinBindingSetIterator iterator = new PCJKeyToJoinBindingSetIterator((BatchScanner)scanner, this.getTableVarMap(), maxPrefixLen);
            return new BindingSetHashJoinIterator((Multimap<String, BindingSet>)bindingSetHashMap, iterator, (Set<String>)unAssuredVariables, joinType);
        }
        catch (Exception e) {
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    private String getHashJoinKey(String commonVarOrder, BindingSet bs) {
        String[] commonVarArray = commonVarOrder.split(";");
        String key = bs.getValue(commonVarArray[0]).toString();
        for (int i = 1; i < commonVarArray.length; ++i) {
            key = key + "\u0000" + bs.getValue(commonVarArray[i]).toString();
        }
        return key;
    }

    private Range getRange(String commonVarOrder, BindingSet bs) throws BindingSetConverter.BindingSetConversionException {
        AccumuloPcjSerializer converter = new AccumuloPcjSerializer();
        byte[] rangePrefix = new byte[]{};
        rangePrefix = converter.convert(bs, new VariableOrder(commonVarOrder));
        return Range.prefix((Text)new Text(rangePrefix));
    }

    private BindingSetVariableOrder getVarOrder(Set<String> variableBindingNames, Set<String> constantBindingNames) {
        Set<String> variables;
        Map<String, Set<String>> varOrderMap = this.getSupportedVariableOrders();
        Set<Map.Entry<String, Set<String>>> entries = varOrderMap.entrySet();
        if (variableBindingNames.size() == 0 && constantBindingNames.size() == 0) {
            return new BindingSetVariableOrder("", 0, new HashSet<String>());
        }
        if (variableBindingNames.size() > 0 && constantBindingNames.size() == 0) {
            variables = variableBindingNames;
        } else if (variableBindingNames.size() == 0 && constantBindingNames.size() > 0) {
            variables = constantBindingNames;
        } else {
            Sets.SetView variables2 = Sets.union(variableBindingNames, constantBindingNames);
            String maxPrefix = null;
            int maxPrefixLen = 0;
            Sets.SetView minUnusedVariables = null;
            for (Map.Entry<String, Set<String>> e : entries) {
                Set<String> value = e.getValue();
                if (maxPrefixLen >= value.size() || !variables2.containsAll(value) || Sets.intersection(value, variableBindingNames).size() <= 0) continue;
                maxPrefixLen = value.size();
                maxPrefix = e.getKey();
                minUnusedVariables = Sets.difference((Set)variables2, value);
                if (maxPrefixLen != variables2.size()) continue;
                break;
            }
            return new BindingSetVariableOrder(maxPrefix, maxPrefixLen, (Set<String>)minUnusedVariables);
        }
        String maxPrefix = null;
        int maxPrefixLen = 0;
        Sets.SetView minUnusedVariables = null;
        for (Map.Entry<String, Set<String>> e : entries) {
            Set<String> value = e.getValue();
            if (maxPrefixLen >= value.size() || !variables.containsAll(value)) continue;
            maxPrefixLen = value.size();
            maxPrefix = e.getKey();
            minUnusedVariables = Sets.difference(variables, value);
            if (maxPrefixLen != variables.size()) continue;
            break;
        }
        return new BindingSetVariableOrder(maxPrefix, maxPrefixLen, (Set<String>)minUnusedVariables);
    }

    private BindingSet getConstantConstraints() {
        Map<String, String> tableMap = this.getTableVarMap();
        Set<String> keys = tableMap.keySet();
        QueryBindingSet constants = new QueryBindingSet();
        for (String s : keys) {
            if (!VarNameUtils.isConstant((String)s)) continue;
            constants.addBinding((Binding)new SimpleBinding(s, this.getConstantValueMap().get(s)));
        }
        return constants;
    }

    private String prefixToOrder(String order) {
        BiMap invMap = HashBiMap.create(this.getTableVarMap()).inverse();
        Object[] temp = order.split(";");
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = this.getTableVarMap().get(temp[i]);
        }
        order = Joiner.on((String)";").join(temp);
        for (String s : this.varOrder) {
            if (!s.startsWith(order)) continue;
            return s;
        }
        throw new NoSuchElementException("Order is not a prefix of any locality group value!");
    }

    private class BindingSetVariableOrder {
        Set<String> unusedVars;
        int varOrderLen = 0;
        String varOrder;

        public BindingSetVariableOrder(String varOrder, int len, Set<String> unused) {
            this.varOrder = varOrder;
            this.varOrderLen = len;
            this.unusedVars = unused;
        }
    }
}

