/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public class TopOfQueryFilterRelocator {
    public static TupleExpr moveFiltersToTop(TupleExpr query) {
        ProjectionAndFilterGatherer fg = new ProjectionAndFilterGatherer();
        query.visit((QueryModelVisitor)fg);
        ArrayList<ValueExpr> filterCond = new ArrayList<ValueExpr>(fg.filterCond);
        Projection projection = fg.projection;
        if (filterCond.size() == 0) {
            return query;
        }
        Filter first = new Filter();
        first.setCondition((ValueExpr)filterCond.remove(0));
        Filter current = first;
        for (ValueExpr cond : filterCond) {
            Filter filter = new Filter(null, cond);
            current.setArg((TupleExpr)filter);
            current = filter;
        }
        TupleExpr te = projection.getArg();
        projection.setArg((TupleExpr)first);
        current.setArg(te);
        return query;
    }

    static class ProjectionAndFilterGatherer
    extends AbstractQueryModelVisitor<RuntimeException> {
        Set<ValueExpr> filterCond = new HashSet<ValueExpr>();
        Projection projection;

        ProjectionAndFilterGatherer() {
        }

        public void meet(Projection node) {
            this.projection = node;
            node.getArg().visit((QueryModelVisitor)this);
        }

        public void meet(Filter node) {
            this.filterCond.add(node.getCondition());
            node.replaceWith((QueryModelNode)node.getArg());
        }
    }
}

