/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Preconditions;
import org.apache.rya.indexing.external.matching.JoinSegment;
import org.apache.rya.indexing.external.matching.MatcherUtilities;
import org.apache.rya.indexing.external.matching.OptionalJoinSegment;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class QuerySegmentFactory<T extends ExternalSet> {
    public QuerySegment<T> getQuerySegment(QueryModelNode node) {
        Preconditions.checkNotNull((Object)node);
        if (node instanceof Filter) {
            Filter filter = (Filter)node;
            if (MatcherUtilities.segmentContainsLeftJoins((TupleExpr)filter)) {
                return new OptionalJoinSegment(filter);
            }
            return new JoinSegment(filter);
        }
        if (node instanceof Join) {
            Join join = (Join)node;
            if (MatcherUtilities.segmentContainsLeftJoins((TupleExpr)join)) {
                return new OptionalJoinSegment(join);
            }
            return new JoinSegment(join);
        }
        if (node instanceof LeftJoin) {
            return new OptionalJoinSegment((LeftJoin)node);
        }
        throw new IllegalArgumentException("Node must be a Join, Filter, or LeftJoin");
    }
}

