/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rya.indexing.external.matching.FlattenedOptional;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class QueryNodesToTupleExpr {
    private List<QueryModelNode> queryNodes;
    private Set<Filter> filters;

    public QueryNodesToTupleExpr(List<QueryModelNode> queryNodes, Set<Filter> filters) {
        this.queryNodes = queryNodes;
        this.filters = filters;
    }

    public TupleExprAndNodes getTupleAndNodes() {
        ArrayList<QueryModelNode> nodeCopy = new ArrayList<QueryModelNode>();
        HashSet<Filter> setCopy = new HashSet<Filter>();
        for (QueryModelNode q : this.queryNodes) {
            nodeCopy.add(q.clone());
        }
        for (Filter f : this.filters) {
            setCopy.add(f.clone());
        }
        TupleExpr te = this.buildQuery(nodeCopy, setCopy);
        return new TupleExprAndNodes(te, nodeCopy, setCopy);
    }

    private TupleExpr buildQuery(List<QueryModelNode> queryNodes, Set<Filter> filters) {
        List<Filter> chain = QueryNodesToTupleExpr.getFilterChain(filters);
        return QueryNodesToTupleExpr.getNewJoin(queryNodes, chain);
    }

    private static List<Filter> getFilterChain(Set<Filter> filters) {
        ArrayList filterTopBottom = Lists.newArrayList();
        Filter filterChainTop = null;
        Filter filterChainBottom = null;
        for (Filter filter : filters) {
            if (filterChainTop == null) {
                filterChainTop = filter;
                filter.setParentNode(null);
                continue;
            }
            if (filterChainBottom == null) {
                filterChainBottom = filter;
                filterChainTop.setArg((TupleExpr)filterChainBottom);
                continue;
            }
            filterChainBottom.setArg((TupleExpr)filter);
            filterChainBottom = filter;
        }
        if (filterChainTop != null) {
            filterTopBottom.add(filterChainTop);
        }
        if (filterChainBottom != null) {
            filterTopBottom.add(filterChainBottom);
        }
        return filterTopBottom;
    }

    private static TupleExpr getNewJoin(List<QueryModelNode> args, List<Filter> filterChain) {
        TupleExpr newJoin;
        ArrayList joinArgs = Lists.newArrayList();
        for (QueryModelNode q : args) {
            if (q instanceof TupleExpr) {
                joinArgs.add(0, (TupleExpr)q);
                continue;
            }
            throw new IllegalArgumentException("Invalid query node!");
        }
        if (joinArgs.size() > 1) {
            TupleExpr left = (TupleExpr)joinArgs.remove(0);
            TupleExpr right = (TupleExpr)joinArgs.remove(0);
            TupleExpr tempJoin = QueryNodesToTupleExpr.getJoin(left, right);
            for (int i = joinArgs.size() - 1; i >= 0; --i) {
                tempJoin = QueryNodesToTupleExpr.getJoin(tempJoin, (TupleExpr)joinArgs.get(i));
            }
            if (filterChain.size() == 0) {
                newJoin = tempJoin;
            } else if (filterChain.size() == 1) {
                newJoin = (TupleExpr)filterChain.get(0);
                ((Filter)newJoin).setArg(tempJoin);
            } else {
                newJoin = (TupleExpr)filterChain.get(0);
                filterChain.get(1).setArg(tempJoin);
            }
        } else if (joinArgs.size() == 1) {
            TupleExpr tempJoin = (TupleExpr)joinArgs.get(0);
            if (filterChain.size() == 0) {
                newJoin = tempJoin;
            } else if (filterChain.size() == 1) {
                newJoin = (TupleExpr)filterChain.get(0);
                ((Filter)newJoin).setArg(tempJoin);
            } else {
                newJoin = (TupleExpr)filterChain.get(0);
                filterChain.get(1).setArg(tempJoin);
            }
        } else {
            throw new IllegalStateException("JoinArgs size cannot be zero.");
        }
        return newJoin;
    }

    private static TupleExpr getJoin(TupleExpr oldJoin, TupleExpr newArg) {
        if (newArg instanceof FlattenedOptional) {
            return new LeftJoin(oldJoin, ((FlattenedOptional)newArg).getRightArg());
        }
        return new Join(oldJoin, newArg);
    }

    public static class TupleExprAndNodes {
        private TupleExpr te;
        private List<QueryModelNode> nodes;
        private Set<Filter> filters;

        public TupleExprAndNodes(TupleExpr te, List<QueryModelNode> nodes, Set<Filter> filters) {
            this.te = te;
            this.nodes = nodes;
            this.filters = filters;
        }

        public TupleExpr getTupleExpr() {
            return this.te;
        }

        public List<QueryModelNode> getNodes() {
            return this.nodes;
        }

        public Set<Filter> getFilters() {
            return this.filters;
        }

        public String toString() {
            return "Query: " + this.te + "   Nodes: " + this.nodes;
        }
    }
}

