/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.rya.indexing.external.matching.FlattenedOptional;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class QueryNodeConsolidator {
    private TreeSet<PositionNode> leftJoinPosSet = new TreeSet<PositionNode>(new PositionComparator());
    private TreeSet<PositionNode> extSetPosSet = new TreeSet<PositionNode>(new PositionComparator());
    private TreeSet<PositionNode> lowerBoundSet = new TreeSet<PositionNode>(new PositionComparator());
    private TreeSet<PositionNode> upperBoundSet = new TreeSet<PositionNode>(new PositionComparator());
    private int greatestLowerBound = -1;
    private int leastUpperBound = Integer.MAX_VALUE;
    private List<QueryModelNode> queryNodes;
    private List<QueryModelNode> extSetNodes;
    private boolean consolidateCalled = false;
    private boolean returnValConsolidate = false;

    public QueryNodeConsolidator(List<QueryModelNode> queryNodes, List<QueryModelNode> extSetNodes) {
        Preconditions.checkArgument((boolean)new HashSet<QueryModelNode>(queryNodes).containsAll(new HashSet<QueryModelNode>(extSetNodes)));
        this.queryNodes = new ArrayList<QueryModelNode>(queryNodes);
        this.extSetNodes = new ArrayList<QueryModelNode>(extSetNodes);
        int i = 0;
        for (QueryModelNode q : queryNodes) {
            if (q instanceof FlattenedOptional) {
                this.leftJoinPosSet.add(new PositionNode(q, i));
            }
            if (extSetNodes.contains(q)) {
                this.extSetPosSet.add(new PositionNode(q, i));
            }
            ++i;
        }
    }

    public boolean consolidateNodes() {
        if (this.consolidateCalled) {
            return this.returnValConsolidate;
        }
        this.consolidateCalled = true;
        this.returnValConsolidate = this.consolidate() && this.reOrderExtSetNodes();
        return this.returnValConsolidate;
    }

    public List<QueryModelNode> getQueryNodes() {
        return this.queryNodes;
    }

    private boolean reOrderExtSetNodes() {
        int pos = this.extSetPosSet.last().getPosition();
        for (int j = this.extSetNodes.size() - 1; j >= 0; --j) {
            QueryModelNode node = this.extSetNodes.get(j);
            int i = this.queryNodes.indexOf(node);
            if (!this.moveQueryNode(new PositionNode(node = this.queryNodes.get(i), i), pos)) {
                return false;
            }
            --pos;
        }
        return true;
    }

    private boolean consolidate() {
        while (this.canConsolidate()) {
            Move move = this.getNextMove();
            if (move.isEmpty) {
                return true;
            }
            this.moveQueryNode(move.node, move.finalPos);
        }
        return false;
    }

    private boolean canConsolidate() {
        if (this.greatestLowerBound < this.leastUpperBound) {
            return true;
        }
        return this.adjustBounds();
    }

    private boolean adjustBounds() {
        int finalPos = this.extSetPosSet.first().getPosition();
        PositionNode node = this.lowerBoundSet.last();
        return this.moveQueryNode(node, finalPos);
    }

    private Move getNextMove() {
        Iterator<PositionNode> posIterator = this.extSetPosSet.iterator();
        if (!posIterator.hasNext()) {
            throw new IllegalStateException("PCJ has no nodes!");
        }
        PositionNode current = posIterator.next();
        int pos1 = -1;
        int pos2 = -1;
        while (posIterator.hasNext()) {
            PositionNode next = posIterator.next();
            pos1 = current.getPosition();
            if (pos1 + 1 < (pos2 = next.getPosition())) {
                if (this.leastUpperBound > pos2) {
                    return new Move(current, pos2 - 1);
                }
                if (this.greatestLowerBound < pos1) {
                    return new Move(next, pos1 + 1);
                }
                return new Move(current, this.greatestLowerBound);
            }
            current = next;
        }
        return new Move();
    }

    private boolean moveQueryNode(PositionNode node, int position) {
        if (!this.canMoveNode(node, position)) {
            if (this.upperBoundSet.size() > 0) {
                this.leastUpperBound = this.upperBoundSet.first().getPosition();
            }
            if (this.lowerBoundSet.size() > 0) {
                this.greatestLowerBound = this.lowerBoundSet.last().getPosition();
            }
            return false;
        }
        this.updateLeftJoinNodes(node, position);
        this.updateNodeList(node, position, this.queryNodes);
        this.updatePositionNodeSet(node, position, this.lowerBoundSet);
        this.updatePositionNodeSet(node, position, this.upperBoundSet);
        if (this.upperBoundSet.size() > 0) {
            this.leastUpperBound = this.upperBoundSet.first().getPosition();
        }
        if (this.lowerBoundSet.size() > 0) {
            this.greatestLowerBound = this.lowerBoundSet.last().getPosition();
        }
        this.updatePositionNodeSet(node, position, this.leftJoinPosSet);
        this.updatePositionNode(node, position, this.extSetPosSet);
        return true;
    }

    private boolean canMoveNode(PositionNode node, int finalPos) {
        PositionNode bound = this.getBounds(node, finalPos, this.queryNodes, this.leftJoinPosSet);
        if (bound.isEmpty) {
            return true;
        }
        this.addBound(bound, node, finalPos);
        return false;
    }

    private void addBound(PositionNode bound, PositionNode node, int finalPos) {
        int diff = finalPos - node.getPosition();
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            if (this.upperBoundSet.contains(bound)) {
                return;
            }
            this.upperBoundSet.add(bound);
        } else {
            if (this.lowerBoundSet.contains(bound)) {
                return;
            }
            this.lowerBoundSet.add(bound);
        }
    }

    private void updatePositionNodeSet(PositionNode node, int position, TreeSet<PositionNode> set) {
        if (set.size() == 0) {
            return;
        }
        int oldPos = node.getPosition();
        int diff = position - oldPos;
        boolean containsNode = false;
        if (diff == 0) {
            return;
        }
        if (set.contains(node)) {
            containsNode = true;
            set.remove(node);
        }
        if (diff > 0) {
            NavigableSet<PositionNode> posNodes = set.subSet(node, false, new PositionNode(position), true);
            ArrayList<PositionNode> pNodeList = new ArrayList<PositionNode>();
            for (PositionNode pos : posNodes) {
                pNodeList.add(pos);
            }
            for (PositionNode pos : pNodeList) {
                int p = pos.getPosition() - 1;
                this.updatePositionNode(pos, p, set);
            }
        } else {
            NavigableSet<PositionNode> posNodes = set.subSet(new PositionNode(position), true, node, false);
            ArrayList<PositionNode> pNodeList = new ArrayList<PositionNode>();
            for (PositionNode pos : posNodes) {
                pNodeList.add(pos);
            }
            for (int i = pNodeList.size() - 1; i >= 0; --i) {
                PositionNode pNode = (PositionNode)pNodeList.get(i);
                int p = pNode.getPosition() + 1;
                this.updatePositionNode(pNode, p, set);
            }
        }
        if (containsNode) {
            node.setPosition(position);
            set.add(node);
        }
    }

    private void updateLeftJoinNodes(PositionNode node, int finalPos) {
        if (node.getNode() instanceof ValueExpr) {
            return;
        }
        int diff = finalPos - node.getPosition();
        if (diff == 0) {
            return;
        }
        if (node.isOptional) {
            int i;
            this.leftJoinPosSet.remove(node);
            FlattenedOptional optional = (FlattenedOptional)node.getNode();
            if (diff < 0) {
                for (i = node.getPosition() - 1; i > finalPos - 1; --i) {
                    QueryModelNode tempNode = this.queryNodes.get(i);
                    if (tempNode instanceof ValueExpr) continue;
                    optional.addArg((TupleExpr)tempNode);
                }
            } else {
                for (i = node.getPosition() + 1; i < finalPos + 1; ++i) {
                    QueryModelNode tempNode = this.queryNodes.get(i);
                    if (tempNode instanceof ValueExpr) continue;
                    optional.removeArg((TupleExpr)tempNode);
                }
            }
            node.setNode((QueryModelNode)optional);
            int index = this.queryNodes.indexOf((Object)optional);
            this.queryNodes.remove((Object)optional);
            this.queryNodes.add(index, (QueryModelNode)optional);
            this.leftJoinPosSet.add(node);
        } else {
            TupleExpr te = (TupleExpr)node.getNode();
            if (diff < 0) {
                NavigableSet<PositionNode> optionals = this.leftJoinPosSet.subSet(new PositionNode(finalPos), true, node, false);
                for (PositionNode pNode : optionals) {
                    FlattenedOptional optional = (FlattenedOptional)pNode.getNode();
                    optional.removeArg(te);
                }
            } else {
                NavigableSet<PositionNode> optionals = this.leftJoinPosSet.subSet(node, false, new PositionNode(finalPos), true);
                for (PositionNode pNode : optionals) {
                    FlattenedOptional optional = (FlattenedOptional)pNode.getNode();
                    optional.addArg(te);
                }
            }
        }
    }

    private void updatePositionNode(PositionNode node, int position, TreeSet<PositionNode> set) {
        set.remove(node);
        node.setPosition(position);
        set.add(node);
    }

    private void updateNodeList(PositionNode node, int finalPos, List<QueryModelNode> list) {
        int initialPos = node.getPosition();
        QueryModelNode qNode = list.remove(initialPos);
        if (finalPos < list.size()) {
            list.add(finalPos, qNode);
        } else {
            list.add(qNode);
        }
    }

    private PositionNode getBounds(PositionNode node, int finalPos, List<QueryModelNode> list, TreeSet<PositionNode> leftJoinNodes) {
        if (node.getNode() instanceof ValueExpr) {
            return new PositionNode();
        }
        int diff = finalPos - node.getPosition();
        if (diff == 0) {
            return new PositionNode();
        }
        if (node.isOptional) {
            FlattenedOptional optional = ((FlattenedOptional)node.getNode()).clone();
            if (diff < 0) {
                for (int i = node.getPosition() - 1; i > finalPos - 1; --i) {
                    FlattenedOptional tempOptional;
                    QueryModelNode tempNode = list.get(i);
                    if (tempNode instanceof ValueExpr) continue;
                    if (!optional.canAddTuple((TupleExpr)tempNode)) {
                        return new PositionNode(tempNode, i);
                    }
                    if (tempNode instanceof FlattenedOptional && !(tempOptional = (FlattenedOptional)tempNode).canRemoveTuple(optional)) {
                        return new PositionNode(tempNode, i);
                    }
                    optional.addArg((TupleExpr)tempNode);
                }
            } else {
                for (int i = node.getPosition() + 1; i < finalPos + 1; ++i) {
                    FlattenedOptional tempOptional;
                    QueryModelNode tempNode = list.get(i);
                    if (tempNode instanceof ValueExpr) continue;
                    if (!optional.canRemoveTuple((TupleExpr)tempNode)) {
                        return new PositionNode(tempNode, i);
                    }
                    if (tempNode instanceof FlattenedOptional && !(tempOptional = (FlattenedOptional)tempNode).canAddTuple(optional)) {
                        return new PositionNode(tempNode, i);
                    }
                    optional.removeArg((TupleExpr)tempNode);
                }
            }
            return new PositionNode();
        }
        TupleExpr te = (TupleExpr)node.getNode();
        if (diff < 0) {
            NavigableSet<PositionNode> leftJoins = leftJoinNodes.subSet(new PositionNode(finalPos), true, node, false);
            for (PositionNode pNode : leftJoins) {
                FlattenedOptional optional = (FlattenedOptional)pNode.getNode();
                if (optional.canRemoveTuple(te)) continue;
                return new PositionNode(pNode);
            }
        } else {
            NavigableSet<PositionNode> leftJoins = leftJoinNodes.subSet(node, false, new PositionNode(finalPos), true);
            for (PositionNode pNode : leftJoins) {
                FlattenedOptional optional = (FlattenedOptional)pNode.getNode();
                if (optional.canAddTuple(te)) continue;
                return new PositionNode(pNode);
            }
        }
        return new PositionNode();
    }

    class PositionComparator
    implements Comparator<PositionNode> {
        PositionComparator() {
        }

        @Override
        public int compare(PositionNode node1, PositionNode node2) {
            if (node1.position < node2.position) {
                return -1;
            }
            if (node1.position > node2.position) {
                return 1;
            }
            return 0;
        }
    }

    static class PositionNode {
        private int position;
        private QueryModelNode node;
        private boolean isOptional = false;
        boolean isEmpty = true;

        public PositionNode(QueryModelNode node, int position) {
            this.node = node;
            this.position = position;
            this.isOptional = node instanceof FlattenedOptional;
            this.isEmpty = false;
        }

        public PositionNode(PositionNode node) {
            this(node.node, node.position);
        }

        public PositionNode(int position) {
            this.position = position;
            this.isEmpty = false;
        }

        public PositionNode() {
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public QueryModelNode getNode() {
            return this.node;
        }

        public void setNode(QueryModelNode node) {
            this.node = node;
        }

        public boolean isOptional() {
            return this.isOptional;
        }

        public String toString() {
            return "Node: " + this.node + " Position: " + this.position;
        }
    }

    static class Move {
        PositionNode node;
        int finalPos;
        boolean isEmpty = true;

        public Move(PositionNode node, int finalPos) {
            this.node = node;
            this.finalPos = finalPos;
            this.isEmpty = false;
        }

        public Move() {
        }
    }
}

