/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.rya.indexing.external.matching.AbstractExternalSetMatcher;
import org.apache.rya.indexing.external.matching.BasicRater;
import org.apache.rya.indexing.external.matching.ExternalSetConverter;
import org.apache.rya.indexing.external.matching.OptionalJoinSegment;
import org.apache.rya.indexing.external.matching.QueryNodeConsolidator;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class OptionalJoinSegmentMatcher<T extends ExternalSet>
extends AbstractExternalSetMatcher<T> {
    private ExternalSetConverter<T> converter;

    public OptionalJoinSegmentMatcher(QuerySegment<T> segment, ExternalSetConverter<T> converter) {
        Preconditions.checkNotNull(segment);
        Preconditions.checkNotNull(converter);
        this.segment = segment;
        this.segmentNodeList = new ArrayList<QueryModelNode>(segment.getOrderedNodes());
        this.converter = converter;
    }

    @Override
    protected boolean match(QuerySegment<T> nodes, T set) {
        Preconditions.checkNotNull(nodes);
        Preconditions.checkNotNull(set);
        if (!this.segment.containsQuerySegment(nodes)) {
            return false;
        }
        List<QueryModelNode> consolidatedNodes = this.groupNodesToMatchExternalSet(this.getOrderedNodes(), nodes.getOrderedNodes());
        if (consolidatedNodes.size() == 0) {
            return false;
        }
        this.segment.setNodes(consolidatedNodes);
        boolean nodesReplaced = this.segment.replaceWithExternalSet(nodes, set);
        if (nodesReplaced) {
            this.updateTupleAndNodes();
        } else {
            this.segment.setNodes(this.segmentNodeList);
        }
        return nodesReplaced;
    }

    private List<QueryModelNode> groupNodesToMatchExternalSet(List<QueryModelNode> queryNodes, List<QueryModelNode> externalSetNodes) {
        QueryNodeConsolidator pnc = new QueryNodeConsolidator(queryNodes, externalSetNodes);
        boolean canConsolidate = pnc.consolidateNodes();
        if (canConsolidate) {
            return pnc.getQueryNodes();
        }
        return new ArrayList<QueryModelNode>();
    }

    @Override
    public boolean match(T set) {
        Preconditions.checkNotNull(set);
        QuerySegment<T> segment = this.converter.setToSegment(set);
        return this.match(segment, set);
    }

    @Override
    public QuerySegment<T> match(Iterator<List<T>> sets, Optional<QueryNodeListRater> r) {
        QueryNodeListRater rater = null;
        rater = r.isPresent() ? (QueryNodeListRater)r.get() : new BasicRater(this.segmentNodeList);
        double min = Double.MAX_VALUE;
        double temp = 0.0;
        QuerySegment<T> minSegment = null;
        while (sets.hasNext()) {
            QuerySegment<T> tempSegment = this.match((Collection)sets.next());
            temp = rater.rateQuerySegment(tempSegment.getOrderedNodes());
            if (!(temp < min)) continue;
            min = temp;
            minSegment = tempSegment;
        }
        return minSegment;
    }

    @Override
    public QuerySegment<T> match(Collection<T> sets) {
        Preconditions.checkNotNull(sets);
        Object copy = ((OptionalJoinSegment)this.segment).clone();
        for (ExternalSet set : sets) {
            QuerySegment<ExternalSet> nodes = this.converter.setToSegment(set);
            if (!copy.containsQuerySegment(nodes)) continue;
            List<QueryModelNode> consolidatedNodes = this.groupNodesToMatchExternalSet(copy.getOrderedNodes(), nodes.getOrderedNodes());
            if (consolidatedNodes.size() == 0) {
                return copy;
            }
            copy.setNodes(consolidatedNodes);
            copy.replaceWithExternalSet(nodes, set);
        }
        return copy;
    }
}

