/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.indexing.external.matching.AbstractQuerySegment;
import org.apache.rya.indexing.external.matching.FlattenedOptional;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.rdftriplestore.inference.DoNotExpandSP;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class OptionalJoinSegment<T extends ExternalSet>
extends AbstractQuerySegment<T> {
    public OptionalJoinSegment(Join join) {
        Preconditions.checkNotNull((Object)join);
        this.createJoinSegment((TupleExpr)join);
    }

    public OptionalJoinSegment(LeftJoin join) {
        Preconditions.checkNotNull((Object)join);
        this.createJoinSegment((TupleExpr)join);
    }

    public OptionalJoinSegment(Filter filter) {
        Preconditions.checkNotNull((Object)filter);
        this.createJoinSegment((TupleExpr)filter);
    }

    public OptionalJoinSegment(Set<QueryModelNode> unorderedNodes, List<QueryModelNode> orderedNodes, Map<ValueExpr, Filter> filterMap) {
        this.unorderedNodes = unorderedNodes;
        this.orderedNodes = orderedNodes;
        this.conditionMap = filterMap;
    }

    private void createJoinSegment(TupleExpr te) {
        this.orderedNodes = this.getJoinArgs(te, this.orderedNodes);
        this.unorderedNodes = Sets.newHashSet((Iterable)this.orderedNodes);
    }

    @Override
    public boolean replaceWithExternalSet(QuerySegment<T> segment, T set) {
        Preconditions.checkNotNull((Object)(segment != null ? 1 : 0));
        Preconditions.checkNotNull(set);
        if (!this.containsQuerySegment(segment)) {
            return false;
        }
        List<QueryModelNode> nodeList = segment.getOrderedNodes();
        int begin = this.orderedNodes.indexOf(nodeList.get(0));
        if (begin < 0 || begin + nodeList.size() > this.orderedNodes.size() || !nodeList.equals(this.orderedNodes.subList(begin, begin + nodeList.size()))) {
            return false;
        }
        this.orderedNodes.removeAll(nodeList);
        this.orderedNodes.add(begin, set);
        this.unorderedNodes.removeAll(nodeList);
        this.unorderedNodes.add(set);
        for (QueryModelNode q : nodeList) {
            if (!(q instanceof ValueExpr)) continue;
            this.conditionMap.remove(q);
        }
        return true;
    }

    private List<QueryModelNode> getJoinArgs(TupleExpr tupleExpr, List<QueryModelNode> joinArgs) {
        if (tupleExpr instanceof Join) {
            if (!(((Join)tupleExpr).getLeftArg() instanceof FixedStatementPattern) && !(((Join)tupleExpr).getRightArg() instanceof DoNotExpandSP)) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getRightArg(), joinArgs);
                this.getJoinArgs(join.getLeftArg(), joinArgs);
            }
        } else if (tupleExpr instanceof LeftJoin) {
            LeftJoin lj = (LeftJoin)tupleExpr;
            joinArgs.add((QueryModelNode)new FlattenedOptional(lj));
            this.getJoinArgs(lj.getLeftArg(), joinArgs);
        } else if (tupleExpr instanceof Filter) {
            Filter filter = (Filter)tupleExpr;
            joinArgs.add((QueryModelNode)filter.getCondition());
            this.conditionMap.put(filter.getCondition(), filter);
            this.getJoinArgs(filter.getArg(), joinArgs);
        } else {
            joinArgs.add((QueryModelNode)tupleExpr);
        }
        return joinArgs;
    }

    public OptionalJoinSegment<T> clone() {
        ArrayList<QueryModelNode> order = new ArrayList<QueryModelNode>();
        for (QueryModelNode node : this.orderedNodes) {
            order.add(node.clone());
        }
        HashSet unorder = Sets.newHashSet(order);
        HashMap<ValueExpr, Filter> map = new HashMap<ValueExpr, Filter>();
        for (ValueExpr expr : this.conditionMap.keySet()) {
            map.put(expr.clone(), ((Filter)this.conditionMap.get(expr)).clone());
        }
        return new OptionalJoinSegment<T>(unorder, order, map);
    }
}

