/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.rya.indexing.external.matching.AbstractExternalSetMatcher;
import org.apache.rya.indexing.external.matching.BasicRater;
import org.apache.rya.indexing.external.matching.ExternalSetConverter;
import org.apache.rya.indexing.external.matching.JoinSegment;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class JoinSegmentMatcher<T extends ExternalSet>
extends AbstractExternalSetMatcher<T> {
    private ExternalSetConverter<T> converter;

    public JoinSegmentMatcher(QuerySegment<T> segment, ExternalSetConverter<T> converter) {
        Preconditions.checkNotNull(segment);
        Preconditions.checkNotNull(converter);
        Preconditions.checkArgument((boolean)(segment instanceof JoinSegment));
        this.segment = segment;
        this.segmentNodeList = new ArrayList<QueryModelNode>(segment.getOrderedNodes());
        this.converter = converter;
    }

    @Override
    protected boolean match(QuerySegment<T> nodes, T set) {
        Preconditions.checkArgument((boolean)(nodes instanceof JoinSegment));
        boolean nodesReplaced = this.segment.replaceWithExternalSet(nodes, set);
        if (nodesReplaced) {
            this.updateTupleAndNodes();
        }
        return nodesReplaced;
    }

    @Override
    public boolean match(T set) {
        Preconditions.checkNotNull(set);
        QuerySegment<T> segment = this.converter.setToSegment(set);
        return this.match(segment, set);
    }

    @Override
    public QuerySegment<T> match(Iterator<List<T>> sets, Optional<QueryNodeListRater> r) {
        QueryNodeListRater rater = null;
        rater = r.isPresent() ? (QueryNodeListRater)r.get() : new BasicRater(this.segmentNodeList);
        double min = Double.MAX_VALUE;
        double temp = 0.0;
        QuerySegment<T> minSegment = null;
        while (sets.hasNext()) {
            QuerySegment<T> tempSegment = this.match((Collection)sets.next());
            temp = rater.rateQuerySegment(tempSegment.getOrderedNodes());
            if (!(temp < min)) continue;
            min = temp;
            minSegment = tempSegment;
        }
        return minSegment;
    }

    @Override
    public QuerySegment<T> match(Collection<T> sets) {
        Preconditions.checkNotNull(sets);
        Object copy = ((JoinSegment)this.segment).clone();
        for (ExternalSet set : sets) {
            QuerySegment<ExternalSet> nodes = this.converter.setToSegment(set);
            copy.replaceWithExternalSet(nodes, set);
        }
        return copy;
    }
}

