/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.indexing.external.matching.AbstractQuerySegment;
import org.apache.rya.indexing.external.matching.MatcherUtilities;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.rdftriplestore.inference.DoNotExpandSP;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public class JoinSegment<T extends ExternalSet>
extends AbstractQuerySegment<T> {
    public JoinSegment(Join join) {
        Preconditions.checkNotNull((Object)join);
        Preconditions.checkArgument((!MatcherUtilities.segmentContainsLeftJoins((TupleExpr)join) ? 1 : 0) != 0);
        this.createJoinSegment((TupleExpr)join);
    }

    public JoinSegment(Filter filter) {
        Preconditions.checkNotNull((Object)filter);
        Preconditions.checkArgument((!MatcherUtilities.segmentContainsLeftJoins((TupleExpr)filter) ? 1 : 0) != 0);
        this.createJoinSegment((TupleExpr)filter);
    }

    public JoinSegment(Set<QueryModelNode> unorderedNodes, List<QueryModelNode> orderedNodes, Map<ValueExpr, Filter> filterMap) {
        this.unorderedNodes = unorderedNodes;
        this.orderedNodes = orderedNodes;
        this.conditionMap = filterMap;
    }

    private void createJoinSegment(TupleExpr te) {
        this.orderedNodes = this.getJoinArgs(te, this.orderedNodes);
        this.unorderedNodes = Sets.newHashSet((Iterable)this.orderedNodes);
    }

    @Override
    public boolean replaceWithExternalSet(QuerySegment<T> nodeToReplace, T set) {
        Preconditions.checkNotNull(nodeToReplace);
        Preconditions.checkNotNull(set);
        if (!this.containsQuerySegment(nodeToReplace)) {
            return false;
        }
        Set<QueryModelNode> nodeSet = nodeToReplace.getUnOrderedNodes();
        this.orderedNodes.removeAll(nodeSet);
        this.orderedNodes.add(set);
        this.unorderedNodes.removeAll(nodeSet);
        this.unorderedNodes.add(set);
        for (QueryModelNode q : nodeSet) {
            if (!(q instanceof ValueExpr)) continue;
            this.conditionMap.remove(q);
        }
        return true;
    }

    private List<QueryModelNode> getJoinArgs(TupleExpr tupleExpr, List<QueryModelNode> joinArgs) {
        if (tupleExpr instanceof Join) {
            if (!(((Join)tupleExpr).getLeftArg() instanceof FixedStatementPattern) && !(((Join)tupleExpr).getRightArg() instanceof DoNotExpandSP)) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getRightArg(), joinArgs);
                this.getJoinArgs(join.getLeftArg(), joinArgs);
            }
        } else if (tupleExpr instanceof Filter) {
            Filter filter = (Filter)tupleExpr;
            joinArgs.add((QueryModelNode)filter.getCondition());
            this.conditionMap.put(filter.getCondition(), filter);
            this.getJoinArgs(filter.getArg(), joinArgs);
        } else {
            joinArgs.add((QueryModelNode)tupleExpr);
        }
        return joinArgs;
    }

    public JoinSegment<T> clone() {
        ArrayList<QueryModelNode> order = new ArrayList<QueryModelNode>();
        for (QueryModelNode node : this.orderedNodes) {
            order.add(node.clone());
        }
        HashSet unorder = Sets.newHashSet(order);
        HashMap<ValueExpr, Filter> map = new HashMap<ValueExpr, Filter>();
        for (ValueExpr expr : this.conditionMap.keySet()) {
            map.put(expr.clone(), ((Filter)this.conditionMap.get(expr)).clone());
        }
        return new JoinSegment<T>(unorder, order, map);
    }
}

