/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.rdftriplestore.inference.DoNotExpandSP;
import org.apache.rya.rdftriplestore.utils.FixedStatementPattern;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;

public class FlattenedOptional
extends AbstractQueryModelNode
implements TupleExpr {
    private Set<TupleExpr> rightArgs;
    private Set<String> boundVars;
    private Set<String> unboundVars;
    private Map<String, Integer> leftArgVarCounts = new HashMap<String, Integer>();
    private ValueExpr condition;
    private TupleExpr rightArg;
    private Set<String> bindingNames;
    private Set<String> assuredBindingNames;

    public FlattenedOptional(LeftJoin node) {
        this.rightArgs = this.getJoinArgs(node.getRightArg(), new HashSet<TupleExpr>());
        this.boundVars = this.setWithOutConstants((Set<String>)Sets.intersection((Set)node.getLeftArg().getAssuredBindingNames(), (Set)node.getRightArg().getBindingNames()));
        this.unboundVars = this.setWithOutConstants((Set<String>)Sets.difference((Set)node.getRightArg().getBindingNames(), this.boundVars));
        this.condition = node.getCondition();
        this.rightArg = node.getRightArg();
        this.getVarCounts((TupleExpr)node);
        this.assuredBindingNames = new HashSet<String>(this.leftArgVarCounts.keySet());
        this.bindingNames = new HashSet<String>((Collection<String>)Sets.union(this.assuredBindingNames, this.unboundVars));
    }

    public FlattenedOptional(FlattenedOptional optional) {
        this.rightArgs = optional.rightArgs;
        this.boundVars = optional.boundVars;
        this.unboundVars = optional.unboundVars;
        this.condition = optional.condition;
        this.rightArg = optional.rightArg;
        this.leftArgVarCounts = optional.leftArgVarCounts;
        this.bindingNames = optional.bindingNames;
        this.assuredBindingNames = optional.assuredBindingNames;
    }

    public Set<TupleExpr> getRightArgs() {
        return this.rightArgs;
    }

    public TupleExpr getRightArg() {
        return this.rightArg;
    }

    public void addArg(TupleExpr te) {
        if (te instanceof FlattenedOptional) {
            return;
        }
        this.incrementVarCounts(te.getBindingNames());
    }

    public void removeArg(TupleExpr te) {
        if (te instanceof FlattenedOptional) {
            return;
        }
        this.decrementVarCounts(te.getBindingNames());
    }

    public boolean canAddTuple(TupleExpr te) {
        if (te instanceof FlattenedOptional) {
            FlattenedOptional lj = (FlattenedOptional)te;
            return Sets.intersection((Set)lj.rightArg.getBindingNames(), this.unboundVars).size() <= 0;
        }
        return Sets.intersection((Set)te.getBindingNames(), this.unboundVars).size() == 0;
    }

    public boolean canRemoveTuple(TupleExpr te) {
        return this.canRemove(te);
    }

    public Set<String> getBindingNames() {
        return this.bindingNames;
    }

    public Set<String> getAssuredBindingNames() {
        return this.assuredBindingNames;
    }

    public ValueExpr getCondition() {
        return this.condition;
    }

    public boolean equals(Object other) {
        if (other instanceof FlattenedOptional) {
            FlattenedOptional ljDec = (FlattenedOptional)((Object)other);
            ValueExpr oCond = ljDec.getCondition();
            return this.nullEquals(this.condition, oCond) && ljDec.getRightArgs().equals(this.rightArgs);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.rightArgs == null ? 0 : this.rightArgs.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    private Set<TupleExpr> getJoinArgs(TupleExpr tupleExpr, Set<TupleExpr> joinArgs) {
        if (tupleExpr instanceof Join) {
            if (!(((Join)tupleExpr).getLeftArg() instanceof FixedStatementPattern) && !(((Join)tupleExpr).getRightArg() instanceof DoNotExpandSP)) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            }
        } else if (tupleExpr instanceof LeftJoin) {
            LeftJoin lj = (LeftJoin)tupleExpr;
            joinArgs.add(new FlattenedOptional(lj));
            this.getJoinArgs(lj.getLeftArg(), joinArgs);
        } else if (tupleExpr instanceof Filter) {
            this.getJoinArgs(((Filter)tupleExpr).getArg(), joinArgs);
        } else {
            joinArgs.add(tupleExpr);
        }
        return joinArgs;
    }

    private void getVarCounts(TupleExpr tupleExpr) {
        if (tupleExpr instanceof Join) {
            Join join = (Join)tupleExpr;
            this.getVarCounts(join.getLeftArg());
            this.getVarCounts(join.getRightArg());
        } else if (tupleExpr instanceof LeftJoin) {
            LeftJoin lj = (LeftJoin)tupleExpr;
            this.getVarCounts(lj.getLeftArg());
        } else if (tupleExpr instanceof Filter) {
            this.getVarCounts(((Filter)tupleExpr).getArg());
        } else {
            this.incrementVarCounts(tupleExpr.getBindingNames());
        }
    }

    private boolean canRemove(TupleExpr te) {
        if (te instanceof FlattenedOptional) {
            FlattenedOptional lj = (FlattenedOptional)te;
            return Sets.intersection((Set)lj.getRightArg().getBindingNames(), this.unboundVars).size() <= 0;
        }
        Set vars = te.getBindingNames();
        Sets.SetView intersection = Sets.intersection((Set)vars, this.boundVars);
        if (intersection.size() == 0) {
            return true;
        }
        for (String s : intersection) {
            if (!this.leftArgVarCounts.containsKey(s) || this.leftArgVarCounts.get(s) != 1) continue;
            return false;
        }
        return true;
    }

    private void incrementVarCounts(Set<String> vars) {
        for (String s : vars) {
            if (!VarNameUtils.isConstant((String)s) && this.leftArgVarCounts.containsKey(s)) {
                this.leftArgVarCounts.put(s, this.leftArgVarCounts.get(s) + 1);
                continue;
            }
            if (VarNameUtils.isConstant((String)s)) continue;
            this.leftArgVarCounts.put(s, 1);
        }
    }

    private void decrementVarCounts(Set<String> vars) {
        for (String s : vars) {
            if (this.leftArgVarCounts.containsKey(s) && this.leftArgVarCounts.get(s) > 1) {
                this.leftArgVarCounts.put(s, this.leftArgVarCounts.get(s) - 1);
                continue;
            }
            this.leftArgVarCounts.remove(s);
            this.bindingNames.remove(s);
            this.assuredBindingNames.remove(s);
        }
    }

    private Set<String> setWithOutConstants(Set<String> vars) {
        HashSet<String> copy = new HashSet<String>();
        for (String s : vars) {
            if (VarNameUtils.isConstant((String)s)) continue;
            copy.add(s);
        }
        return copy;
    }

    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "FlattenedOptional: " + this.rightArgs;
    }

    public FlattenedOptional clone() {
        return new FlattenedOptional(this);
    }
}

