/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rya.api.domain.VarNameUtils;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;

public class BasicRater
implements QueryNodeListRater {
    private List<QueryModelNode> qNodes;

    public BasicRater(List<QueryModelNode> qNodes) {
        this.qNodes = qNodes;
    }

    @Override
    public double rateQuerySegment(List<QueryModelNode> eNodes) {
        return 0.6 * (double)eNodes.size() / (double)this.qNodes.size() + 0.4 * this.getConnectedComponentRating(eNodes);
    }

    private double getConnectedComponentRating(List<QueryModelNode> eNodes) {
        HashMultimap commonVarBin = HashMultimap.create();
        for (int i = 0; i < eNodes.size(); ++i) {
            QueryModelNode node = eNodes.get(i);
            if (!(node instanceof TupleExpr)) continue;
            TupleExpr tup = (TupleExpr)node;
            Set bindingNames = tup.getAssuredBindingNames();
            for (String name : bindingNames) {
                if (VarNameUtils.isConstant((String)name)) continue;
                commonVarBin.put((Object)name, (Object)i);
            }
        }
        HashSet<List<Integer>> pairs = new HashSet<List<Integer>>();
        for (String var : commonVarBin.keySet()) {
            HashSet pos = Sets.newHashSet((Iterable)commonVarBin.get((Object)var));
            pairs.addAll(Sets.cartesianProduct((Set[])new Set[]{pos, pos}));
        }
        int numComponents = this.countComponents(eNodes.size(), pairs);
        return (double)numComponents / (double)eNodes.size();
    }

    public int countComponents(int n, Set<List<Integer>> pairs) {
        int count = n;
        int[] root = new int[n];
        for (int i = 0; i < n; ++i) {
            root[i] = i;
        }
        for (List<Integer> pair : pairs) {
            int yRoot;
            int xRoot;
            int y;
            int x = pair.get(0);
            if (x == (y = pair.get(1).intValue()) || (xRoot = this.getRoot(root, x)) == (yRoot = this.getRoot(root, y))) continue;
            --count;
            root[xRoot] = yRoot;
        }
        return count;
    }

    public int getRoot(int[] arr, int i) {
        while (arr[i] != i) {
            arr[i] = arr[arr[i]];
            i = arr[i];
        }
        return i;
    }
}

