/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rya.indexing.external.matching.QueryNodesToTupleExpr;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public abstract class AbstractQuerySegment<T extends ExternalSet>
implements QuerySegment<T>,
Cloneable {
    protected List<QueryModelNode> orderedNodes = new ArrayList<QueryModelNode>();
    protected Set<QueryModelNode> unorderedNodes = new HashSet<QueryModelNode>();
    protected Map<ValueExpr, Filter> conditionMap = Maps.newHashMap();

    @Override
    public Set<QueryModelNode> getUnOrderedNodes() {
        return Collections.unmodifiableSet(this.unorderedNodes);
    }

    @Override
    public List<QueryModelNode> getOrderedNodes() {
        return Collections.unmodifiableList(this.orderedNodes);
    }

    @Override
    public void setNodes(List<QueryModelNode> nodes) {
        HashSet nodeSet = Sets.newHashSet(nodes);
        Preconditions.checkArgument((boolean)nodeSet.equals(this.unorderedNodes));
        this.orderedNodes = nodes;
        this.unorderedNodes = nodeSet;
    }

    @Override
    public boolean containsQuerySegment(QuerySegment<T> query) {
        return this.unorderedNodes.containsAll(query.getUnOrderedNodes());
    }

    @Override
    public QueryNodesToTupleExpr.TupleExprAndNodes getQuery() {
        ArrayList<QueryModelNode> nodeCopy = new ArrayList<QueryModelNode>();
        for (QueryModelNode q : this.orderedNodes) {
            if (q instanceof ValueExpr) continue;
            nodeCopy.add(q.clone());
        }
        QueryNodesToTupleExpr qnt = new QueryNodesToTupleExpr(nodeCopy, this.getFilters());
        return qnt.getTupleAndNodes();
    }

    @Override
    public Set<Filter> getFilters() {
        Collection<Filter> filters = this.conditionMap.values();
        HashSet<Filter> filterSet = new HashSet<Filter>();
        for (Filter filter : filters) {
            filterSet.add(filter.clone());
        }
        return filterSet;
    }
}

