/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import com.google.common.base.Optional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rya.indexing.external.matching.ExternalSetMatcher;
import org.apache.rya.indexing.external.matching.ExternalSetProvider;
import org.apache.rya.indexing.external.matching.FlattenedOptional;
import org.apache.rya.indexing.external.matching.QueryNodeListRater;
import org.apache.rya.indexing.external.matching.QueryNodesToTupleExpr;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.matching.QuerySegmentFactory;
import org.apache.rya.indexing.pcj.matching.PCJOptimizerUtilities;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

public abstract class AbstractExternalSetOptimizer<T extends ExternalSet>
implements QueryOptimizer {
    protected boolean useOptimal = false;

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        QuerySegmentMatchVisitor visitor = new QuerySegmentMatchVisitor();
        tupleExpr.visit((QueryModelVisitor)visitor);
    }

    private Set<TupleExpr> getUnMatchedArgNodes(List<QueryModelNode> nodes) {
        HashSet<TupleExpr> unmatched = new HashSet<TupleExpr>();
        for (QueryModelNode q : nodes) {
            FlattenedOptional opt;
            TupleExpr rightArg;
            if (q instanceof UnaryTupleOperator || q instanceof BinaryTupleOperator) {
                unmatched.add((TupleExpr)q);
                continue;
            }
            if (!(q instanceof FlattenedOptional) || !((rightArg = (opt = (FlattenedOptional)q).getRightArg()) instanceof UnaryTupleOperator) && !(rightArg instanceof BinaryTupleOperator)) continue;
            unmatched.add(rightArg);
        }
        return unmatched;
    }

    private static boolean checkNode(QueryModelNode node) {
        return node instanceof Join || node instanceof Filter || node instanceof LeftJoin;
    }

    protected abstract ExternalSetMatcher<T> getMatcher(QuerySegment<T> var1);

    protected abstract ExternalSetProvider<T> getProvider();

    protected abstract Optional<QueryNodeListRater> getNodeListRater(QuerySegment<T> var1);

    protected class QuerySegmentMatchVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final QuerySegmentFactory<T> factory = new QuerySegmentFactory();

        protected QuerySegmentMatchVisitor() {
        }

        public void meetNode(QueryModelNode node) {
            if (AbstractExternalSetOptimizer.checkNode(node)) {
                QuerySegment segment = this.factory.getQuerySegment(node);
                ExternalSetProvider provider = AbstractExternalSetOptimizer.this.getProvider();
                ExternalSetMatcher matcher = AbstractExternalSetOptimizer.this.getMatcher(segment);
                QuerySegment tempSeg = null;
                tempSeg = AbstractExternalSetOptimizer.this.useOptimal ? matcher.match(provider.getExternalSetCombos(segment), AbstractExternalSetOptimizer.this.getNodeListRater(segment)) : matcher.match(provider.getExternalSets(segment));
                QueryNodesToTupleExpr.TupleExprAndNodes tups = tempSeg.getQuery();
                node.replaceWith((QueryModelNode)tups.getTupleExpr());
                Set unmatched = AbstractExternalSetOptimizer.this.getUnMatchedArgNodes(tups.getNodes());
                PCJOptimizerUtilities.relocateFilters(tups.getFilters());
                for (TupleExpr tupleExpr : unmatched) {
                    tupleExpr.visit((QueryModelVisitor)this);
                }
            } else {
                super.meetNode(node);
            }
        }
    }
}

