/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.matching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.rya.indexing.external.matching.ExternalSetMatcher;
import org.apache.rya.indexing.external.matching.FlattenedOptional;
import org.apache.rya.indexing.external.matching.QueryNodesToTupleExpr;
import org.apache.rya.indexing.external.matching.QuerySegment;
import org.apache.rya.indexing.external.matching.QuerySegmentFactory;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;

public abstract class AbstractExternalSetMatcher<T extends ExternalSet>
implements ExternalSetMatcher<T> {
    protected QuerySegment<T> segment;
    protected List<QueryModelNode> segmentNodeList;
    protected TupleExpr tuple;
    protected Set<TupleExpr> unmatched;
    protected Set<Filter> filters;
    private final QuerySegmentFactory<T> factory = new QuerySegmentFactory();

    protected abstract boolean match(QuerySegment<T> var1, T var2);

    @Override
    public List<QueryModelNode> getOrderedNodes() {
        return Collections.unmodifiableList(this.segmentNodeList);
    }

    @Override
    public Set<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public TupleExpr getQuery() {
        return this.tuple;
    }

    @Override
    public Set<TupleExpr> getUnmatchedArgNodes() {
        return this.unmatched;
    }

    @Override
    public QuerySegment<T> nodeToQuerySegment(QueryModelNode node) {
        return this.factory.getQuerySegment(node);
    }

    @Override
    public List<QueryModelNode> getAllUnmatchedNodes() {
        ArrayList<QueryModelNode> unmatched = new ArrayList<QueryModelNode>();
        for (QueryModelNode node : this.segmentNodeList) {
            if (node instanceof ExternalSet) continue;
            unmatched.add(node);
        }
        return unmatched;
    }

    protected void updateTupleAndNodes() {
        this.segmentNodeList = this.segment.getOrderedNodes();
        QueryNodesToTupleExpr.TupleExprAndNodes tupAndNodes = this.segment.getQuery();
        this.tuple = tupAndNodes.getTupleExpr();
        this.filters = tupAndNodes.getFilters();
        this.unmatched = new HashSet<TupleExpr>();
        List<QueryModelNode> nodes = tupAndNodes.getNodes();
        for (QueryModelNode q : nodes) {
            FlattenedOptional opt;
            TupleExpr rightArg;
            if (q instanceof UnaryTupleOperator || q instanceof BinaryTupleOperator) {
                this.unmatched.add((TupleExpr)q);
                continue;
            }
            if (!(q instanceof FlattenedOptional) || !((rightArg = (opt = (FlattenedOptional)q).getRightArg()) instanceof UnaryTupleOperator) && !(rightArg instanceof BinaryTupleOperator)) continue;
            this.unmatched.add(rightArg);
        }
    }
}

