/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.fluo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.FluoFactory;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.external.PrecomputedJoinIndexerConfig;
import org.apache.rya.indexing.external.fluo.FluoPcjUpdater;
import org.apache.rya.indexing.external.fluo.FluoPcjUpdaterConfig;
import org.apache.rya.indexing.pcj.update.PrecomputedJoinUpdater;

@DefaultAnnotation(value={NonNull.class})
public class FluoPcjUpdaterSupplier
implements Supplier<PrecomputedJoinUpdater> {
    private final Supplier<Configuration> configSupplier;

    public FluoPcjUpdaterSupplier(Supplier<Configuration> configSupplier) {
        this.configSupplier = (Supplier)Preconditions.checkNotNull(configSupplier);
    }

    public FluoPcjUpdater get() {
        Configuration config = (Configuration)this.configSupplier.get();
        Preconditions.checkNotNull((Object)config, (Object)"Could not create a FluoPcjUpdater because the application's configuration has not been provided yet.");
        PrecomputedJoinIndexerConfig indexerConfig = new PrecomputedJoinIndexerConfig(config);
        Optional<PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType> updaterType = indexerConfig.getPcjUpdaterType();
        Preconditions.checkArgument((updaterType.isPresent() && updaterType.get() == PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType.FLUO ? 1 : 0) != 0, (Object)("This supplier requires the 'rya.indexing.pcj.updaterType' value be set to '" + (Object)((Object)PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType.FLUO) + "'."));
        FluoPcjUpdaterConfig fluoUpdaterConfig = new FluoPcjUpdaterConfig(indexerConfig.getConfig());
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getFluoAppName().isPresent(), (Object)"Missing configuration: rya.indexing.pcj.fluo.fluoAppName");
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getFluoZookeepers().isPresent(), (Object)"Missing configuration: sc.cloudbase.zookeepers");
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getAccumuloZookeepers().isPresent(), (Object)"Missing configuration: sc.cloudbase.zookeepers");
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getAccumuloInstance().isPresent(), (Object)"Missing configuration: sc.cloudbase.instancename");
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getAccumuloUsername().isPresent(), (Object)"Missing configuration: sc.cloudbase.username");
        Preconditions.checkArgument((boolean)fluoUpdaterConfig.getAccumuloPassword().isPresent(), (Object)"Missing configuration: sc.cloudbase.password");
        FluoConfiguration fluoClientConfig = new FluoConfiguration();
        fluoClientConfig.setApplicationName((String)fluoUpdaterConfig.getFluoAppName().get());
        fluoClientConfig.setInstanceZookeepers((String)fluoUpdaterConfig.getFluoZookeepers().get());
        fluoClientConfig.setAccumuloZookeepers((String)fluoUpdaterConfig.getAccumuloZookeepers().get());
        fluoClientConfig.setAccumuloInstance((String)fluoUpdaterConfig.getAccumuloInstance().get());
        fluoClientConfig.setAccumuloUser((String)fluoUpdaterConfig.getAccumuloUsername().get());
        fluoClientConfig.setAccumuloPassword((String)fluoUpdaterConfig.getAccumuloPassword().get());
        FluoClient fluoClient = FluoFactory.newClient((SimpleConfiguration)fluoClientConfig);
        return new FluoPcjUpdater(fluoClient);
    }
}

