/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.fluo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;

public final class FluoPcjUpdaterConfig {
    public static final String FLUO_APP_NAME = "rya.indexing.pcj.fluo.fluoAppName";
    public static final String ACCUMULO_ZOOKEEPERS = "sc.cloudbase.zookeepers";
    public static final String ACCUMULO_INSTANCE = "sc.cloudbase.instancename";
    public static final String ACCUMULO_USERNAME = "sc.cloudbase.username";
    public static final String ACCUMULO_PASSWORD = "sc.cloudbase.password";
    public static final String STATEMENT_VISIBILITY = "query.auth";
    private final Configuration config;

    public FluoPcjUpdaterConfig(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    public Optional<String> getFluoAppName() {
        return Optional.fromNullable((Object)this.config.get(FLUO_APP_NAME));
    }

    public Optional<String> getFluoZookeepers() {
        Optional<String> accumuloZookeepers = this.getAccumuloZookeepers();
        if (!accumuloZookeepers.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)((String)accumuloZookeepers.get() + "/fluo"));
    }

    public Optional<String> getAccumuloZookeepers() {
        return Optional.fromNullable((Object)this.config.get(ACCUMULO_ZOOKEEPERS));
    }

    public Optional<String> getAccumuloInstance() {
        return Optional.fromNullable((Object)this.config.get(ACCUMULO_INSTANCE));
    }

    public Optional<String> getAccumuloUsername() {
        return Optional.fromNullable((Object)this.config.get(ACCUMULO_USERNAME));
    }

    public Optional<String> getAccumuloPassword() {
        return Optional.fromNullable((Object)this.config.get(ACCUMULO_PASSWORD));
    }

    public Optional<String> getStatementVisibility() {
        return Optional.fromNullable((Object)this.config.get(STATEMENT_VISIBILITY));
    }
}

