/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.fluo;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import org.apache.fluo.api.client.FluoClient;
import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.indexing.pcj.fluo.api.InsertTriples;
import org.apache.rya.indexing.pcj.update.PrecomputedJoinUpdater;

@DefaultAnnotation(value={NonNull.class})
public class FluoPcjUpdater
implements PrecomputedJoinUpdater {
    private static final Logger log = Logger.getLogger(FluoPcjUpdater.class);
    private boolean deleteWarningPrinted = false;
    private final FluoClient fluoClient;
    private final InsertTriples insertTriples = new InsertTriples();

    public FluoPcjUpdater(FluoClient fluoClient) {
        this.fluoClient = (FluoClient)Preconditions.checkNotNull((Object)fluoClient);
    }

    public void addStatements(Collection<RyaStatement> statements) throws PrecomputedJoinUpdater.PcjUpdateException {
        this.insertTriples.insert(this.fluoClient, statements);
    }

    public void deleteStatements(Collection<RyaStatement> statements) throws PrecomputedJoinUpdater.PcjUpdateException {
        if (!this.deleteWarningPrinted) {
            log.warn((Object)"The Fluo PCJ updating application does not support Statement deletion, but you are trying to use that feature. This may result in your PCJ index no longer reflecting the Statemetns that are stored in the core Rya tables.");
            this.deleteWarningPrinted = true;
        }
    }

    public void flush() {
    }

    public void close() {
        this.fluoClient.close();
    }
}

