/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external.accumulo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.apache.accumulo.core.client.Connector;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.external.PrecomputedJoinIndexerConfig;
import org.apache.rya.indexing.external.accumulo.AccumuloPcjStorageConfig;
import org.apache.rya.indexing.pcj.storage.accumulo.AccumuloPcjStorage;

public class AccumuloPcjStorageSupplier
implements Supplier<AccumuloPcjStorage> {
    private final Supplier<Configuration> configSupplier;
    private final Supplier<Connector> accumuloSupplier;

    public AccumuloPcjStorageSupplier(Supplier<Configuration> configSupplier, Supplier<Connector> accumuloSupplier) {
        this.configSupplier = (Supplier)Preconditions.checkNotNull(configSupplier);
        this.accumuloSupplier = (Supplier)Preconditions.checkNotNull(accumuloSupplier);
    }

    public AccumuloPcjStorage get() {
        Configuration config = (Configuration)this.configSupplier.get();
        Preconditions.checkNotNull((Object)config, (Object)"Could not create a AccumuloPcjStorage because the application's configuration has not been provided yet.");
        PrecomputedJoinIndexerConfig indexerConfig = new PrecomputedJoinIndexerConfig(config);
        Optional<PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType> storageType = indexerConfig.getPcjStorageType();
        Preconditions.checkArgument((storageType.isPresent() && storageType.get() == PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType.ACCUMULO ? 1 : 0) != 0, (Object)("This supplier requires the 'rya.indexing.pcj.storageType' value be set to '" + (Object)((Object)PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType.ACCUMULO) + "'."));
        Connector accumuloConn = (Connector)this.accumuloSupplier.get();
        Preconditions.checkNotNull((Object)accumuloConn, (Object)"The Accumulo Connector must be set before initializing the AccumuloPcjStorage.");
        String ryaInstanceName = new AccumuloPcjStorageConfig(config).getRyaInstanceName();
        return new AccumuloPcjStorage(accumuloConn, ryaInstanceName);
    }
}

