/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.external.PrecomputedJoinIndexerConfig;
import org.apache.rya.indexing.external.fluo.FluoPcjUpdaterSupplier;
import org.apache.rya.indexing.pcj.update.PrecomputedJoinUpdater;

public class PrecomputedJoinUpdaterSupplier
implements Supplier<PrecomputedJoinUpdater> {
    private final Supplier<Configuration> configSupplier;
    private final FluoPcjUpdaterSupplier fluoSupplier;

    public PrecomputedJoinUpdaterSupplier(Supplier<Configuration> configSupplier, FluoPcjUpdaterSupplier fluoSupplier) {
        this.configSupplier = (Supplier)Preconditions.checkNotNull(configSupplier);
        this.fluoSupplier = (FluoPcjUpdaterSupplier)Preconditions.checkNotNull((Object)fluoSupplier);
    }

    public PrecomputedJoinUpdater get() {
        Configuration config = (Configuration)this.configSupplier.get();
        Preconditions.checkNotNull((Object)config, (Object)"Can not build the PrecomputedJoinUpdater until the PrecomputedJoinIndexer has been configured.");
        PrecomputedJoinIndexerConfig indexerConfig = new PrecomputedJoinIndexerConfig(config);
        Optional<PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType> updaterType = indexerConfig.getPcjUpdaterType();
        Preconditions.checkArgument((boolean)updaterType.isPresent(), (Object)("The 'rya.indexing.pcj.updaterType' property must have one of the following values: " + PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType.values()));
        switch ((PrecomputedJoinIndexerConfig.PrecomputedJoinUpdaterType)((Object)updaterType.get())) {
            case FLUO: {
                return this.fluoSupplier.get();
            }
        }
        throw new IllegalArgumentException("Unsupported PrecomputedJoinUpdaterType: " + updaterType.get());
    }
}

