/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.rya.indexing.external.PrecomputedJoinIndexerConfig;
import org.apache.rya.indexing.external.accumulo.AccumuloPcjStorageSupplier;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;

public class PrecomputedJoinStorageSupplier
implements Supplier<PrecomputedJoinStorage> {
    private final Supplier<Configuration> configSupplier;
    private final AccumuloPcjStorageSupplier accumuloSupplier;

    public PrecomputedJoinStorageSupplier(Supplier<Configuration> configSupplier, AccumuloPcjStorageSupplier accumuloSupplier) {
        this.configSupplier = (Supplier)Preconditions.checkNotNull(configSupplier);
        this.accumuloSupplier = (AccumuloPcjStorageSupplier)Preconditions.checkNotNull((Object)accumuloSupplier);
    }

    public PrecomputedJoinStorage get() {
        Configuration config = (Configuration)this.configSupplier.get();
        Preconditions.checkNotNull((Object)config, (Object)"Could not build the PrecomputedJoinStorage until the PrecomputedJoinIndexer has been configured.");
        PrecomputedJoinIndexerConfig indexerConfig = new PrecomputedJoinIndexerConfig(config);
        Optional<PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType> storageType = indexerConfig.getPcjStorageType();
        Preconditions.checkArgument((boolean)storageType.isPresent(), (Object)("The 'rya.indexing.pcj.storageType' property must have one of the following values: " + Arrays.toString((Object[])PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType.values())));
        switch ((PrecomputedJoinIndexerConfig.PrecomputedJoinStorageType)((Object)storageType.get())) {
            case ACCUMULO: {
                return this.accumuloSupplier.get();
            }
        }
        throw new IllegalArgumentException("Unsupported PrecomputedJoinStorageType: " + storageType.get());
    }
}

