/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.hadoop.conf.Configuration;

@DefaultAnnotation(value={NonNull.class})
public class PrecomputedJoinIndexerConfig {
    public static final String PCJ_STORAGE_TYPE = "rya.indexing.pcj.storageType";
    public static final String PCJ_UPDATER_TYPE = "rya.indexing.pcj.updaterType";
    private final Configuration config;

    public PrecomputedJoinIndexerConfig(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
    }

    public Optional<PrecomputedJoinStorageType> getPcjStorageType() {
        String storageTypeString = this.config.get(PCJ_STORAGE_TYPE);
        if (storageTypeString == null) {
            return Optional.absent();
        }
        PrecomputedJoinStorageType storageType = PrecomputedJoinStorageType.valueOf(storageTypeString);
        return Optional.fromNullable((Object)((Object)storageType));
    }

    public Optional<PrecomputedJoinUpdaterType> getPcjUpdaterType() {
        String updaterTypeString = this.config.get(PCJ_UPDATER_TYPE);
        if (updaterTypeString == null) {
            return Optional.absent();
        }
        PrecomputedJoinUpdaterType updaterType = PrecomputedJoinUpdaterType.valueOf(updaterTypeString);
        return Optional.fromNullable((Object)((Object)updaterType));
    }

    public boolean getUseFluoUpdater() {
        return this.config.getBoolean("sc.use.updater", false);
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static enum PrecomputedJoinUpdaterType {
        FLUO,
        NO_UPDATE;

    }

    public static enum PrecomputedJoinStorageType {
        ACCUMULO,
        MONGO;

    }
}

