/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.external;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.accumulo.experimental.AbstractAccumuloIndexer;
import org.apache.rya.api.RdfCloudTripleStoreConfiguration;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.log.LogUtils;
import org.apache.rya.indexing.external.PrecomputedJoinStorageSupplier;
import org.apache.rya.indexing.external.accumulo.AccumuloPcjStorageSupplier;
import org.apache.rya.indexing.external.fluo.PcjUpdaterSupplierFactory;
import org.apache.rya.indexing.pcj.storage.PrecomputedJoinStorage;
import org.apache.rya.indexing.pcj.update.PrecomputedJoinUpdater;
import org.eclipse.rdf4j.model.IRI;

@DefaultAnnotation(value={NonNull.class})
public class PrecomputedJoinIndexer
extends AbstractAccumuloIndexer {
    private static final Logger log = Logger.getLogger(PrecomputedJoinIndexer.class);
    private Optional<Configuration> conf = Optional.absent();
    private Optional<Connector> accumuloConn = Optional.absent();
    private final Supplier<Configuration> configSupplier = new Supplier<Configuration>(){

        public Configuration get() {
            return PrecomputedJoinIndexer.this.getConf();
        }
    };
    private final Supplier<Connector> accumuloSupplier = new Supplier<Connector>(){

        public Connector get() {
            return (Connector)PrecomputedJoinIndexer.this.accumuloConn.get();
        }
    };
    private final PrecomputedJoinStorageSupplier pcjStorageSupplier = new PrecomputedJoinStorageSupplier(this.configSupplier, new AccumuloPcjStorageSupplier(this.configSupplier, this.accumuloSupplier));
    private PrecomputedJoinStorage pcjStorage;
    private Supplier<PrecomputedJoinUpdater> updaterSupplier;

    public void setConf(Configuration conf) {
        this.conf = Optional.fromNullable((Object)conf);
    }

    public Configuration getConf() {
        return (Configuration)this.conf.get();
    }

    public void setConnector(Connector connector) {
        Preconditions.checkNotNull((Object)connector);
        this.accumuloConn = Optional.of((Object)connector);
    }

    public void init() {
        this.pcjStorage = this.pcjStorageSupplier.get();
        this.updaterSupplier = new PcjUpdaterSupplierFactory(this.configSupplier).getSupplier();
        this.updaterSupplier.get();
    }

    public void storeStatement(RyaStatement statement) throws IOException {
        Preconditions.checkNotNull((Object)statement);
        this.storeStatements(Collections.singleton(statement));
    }

    public void storeStatements(Collection<RyaStatement> statements) throws IOException {
        Preconditions.checkNotNull(statements);
        try {
            ((PrecomputedJoinUpdater)this.updaterSupplier.get()).addStatements(statements);
        }
        catch (PrecomputedJoinUpdater.PcjUpdateException e) {
            throw new IOException("Could not update the PCJs by adding the provided statements.", e);
        }
    }

    public void deleteStatement(RyaStatement statement) throws IOException {
        Preconditions.checkNotNull((Object)statement);
        try {
            Set<RyaStatement> statements = Collections.singleton(statement);
            ((PrecomputedJoinUpdater)this.updaterSupplier.get()).deleteStatements(statements);
        }
        catch (PrecomputedJoinUpdater.PcjUpdateException e) {
            throw new IOException("Could not update the PCJs by removing the provided statement.", e);
        }
    }

    public void flush() throws IOException {
        try {
            ((PrecomputedJoinUpdater)this.updaterSupplier.get()).flush();
        }
        catch (PrecomputedJoinUpdater.PcjUpdateException e) {
            throw new IOException("Could not flush the PCJ Updater.", e);
        }
    }

    public void close() {
        try {
            this.pcjStorage.close();
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            log.error((Object)"Could not close the PCJ Storage instance.", (Throwable)e);
        }
        try {
            ((PrecomputedJoinUpdater)this.updaterSupplier.get()).close();
        }
        catch (PrecomputedJoinUpdater.PcjUpdateException e) {
            log.error((Object)"Could not close the PCJ Updater instance.", (Throwable)e);
        }
    }

    public void destroy() {
        this.close();
    }

    public void purge(RdfCloudTripleStoreConfiguration configuration) {
        try {
            for (String pcjId : this.pcjStorage.listPcjs()) {
                try {
                    this.pcjStorage.purge(pcjId);
                }
                catch (PrecomputedJoinStorage.PCJStorageException e) {
                    log.error((Object)("Could not purge the PCJ index with id: " + LogUtils.clean((String)pcjId)), (Throwable)e);
                }
            }
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            log.error((Object)"Could not purge the PCJ indicies because they could not be listed.", (Throwable)e);
        }
    }

    public void dropAndDestroy() {
        try {
            for (String pcjId : this.pcjStorage.listPcjs()) {
                try {
                    this.pcjStorage.dropPcj(pcjId);
                }
                catch (PrecomputedJoinStorage.PCJStorageException e) {
                    log.error((Object)("Could not delete the PCJ index with id: " + LogUtils.clean((String)pcjId)), (Throwable)e);
                }
            }
        }
        catch (PrecomputedJoinStorage.PCJStorageException e) {
            log.error((Object)"Could not delete the PCJ indicies because they could not be listed.", (Throwable)e);
        }
    }

    public void setMultiTableBatchWriter(MultiTableBatchWriter writer) throws IOException {
    }

    public void dropGraph(RyaIRI ... graphs) {
        log.warn((Object)"PCJ indices do not store Graph metadata, so graph results can not be dropped.");
    }

    public String getTableName() {
        log.warn((Object)"PCJ indicies are not stored within a single table, so this method can not be implemented.");
        return null;
    }

    public Set<IRI> getIndexablePredicates() {
        return new HashSet<IRI>();
    }
}

