/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.update;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.mongodb.update.MongoDocumentUpdater;
import org.apache.rya.indexing.mongodb.update.RyaObjectStorage;

@DefaultAnnotation(value={NonNull.class})
public class EntityUpdater
implements MongoDocumentUpdater<RyaIRI, Entity> {
    private final EntityStorage storage;

    public EntityUpdater(EntityStorage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    @Override
    public void create(Entity newObj) throws EntityStorage.EntityStorageException {
        try {
            this.storage.create(newObj);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new EntityStorage.EntityStorageException(e.getMessage(), e);
        }
    }

    @Override
    public void update(Entity old, Entity updated) throws EntityStorage.EntityStorageException {
        try {
            this.storage.update(old, updated);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new EntityStorage.EntityStorageException(e.getMessage(), e);
        }
    }

    @Override
    public Optional<Entity> getOld(RyaIRI key) throws EntityStorage.EntityStorageException {
        try {
            return this.storage.get(key);
        }
        catch (RyaObjectStorage.ObjectStorageException e) {
            throw new EntityStorage.EntityStorageException(e.getMessage(), e);
        }
    }
}

