/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.update;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaStatement;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.TypeStorage;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.indexing.entity.update.EntityIndexer;
import org.apache.rya.indexing.entity.update.EntityUpdater;
import org.apache.rya.indexing.mongodb.IndexingException;
import org.apache.rya.mongodb.MongoSecondaryIndex;
import org.apache.rya.mongodb.StatefulMongoDBRdfConfiguration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;

@DefaultAnnotation(value={NonNull.class})
public abstract class BaseEntityIndexer
implements EntityIndexer,
MongoSecondaryIndex {
    private static final Logger log = Logger.getLogger(BaseEntityIndexer.class);
    private static final RyaIRI TYPE_IRI = new RyaIRI(RDF.TYPE.toString());
    protected final AtomicReference<StatefulMongoDBRdfConfiguration> configuration = new AtomicReference();
    private final AtomicReference<EntityStorage> entities = new AtomicReference();
    private final AtomicReference<TypeStorage> types = new AtomicReference();

    public void init() {
        try {
            this.entities.set(this.getEntityStorage());
        }
        catch (EntityStorage.EntityStorageException e) {
            log.error((Object)"Unable to set entity storage.");
        }
        this.types.set(this.getTypeStorage());
    }

    public void setConf(Configuration conf) {
        Objects.requireNonNull(conf);
        Preconditions.checkArgument((boolean)(conf instanceof StatefulMongoDBRdfConfiguration), (Object)("The configuration provided must be a StatefulMongoDBRdfConfiguration, found: " + conf.getClass().getSimpleName()));
        this.configuration.set((StatefulMongoDBRdfConfiguration)conf);
    }

    public Configuration getConf() {
        return (Configuration)this.configuration.get();
    }

    public void storeStatement(RyaStatement statement) throws IOException {
        Objects.requireNonNull(statement);
        this.storeStatements(Collections.singleton(statement));
    }

    public void storeStatements(Collection<RyaStatement> statements) throws IOException {
        Objects.requireNonNull(statements);
        Map<RyaIRI, List<RyaStatement>> groupedBySubject = statements.stream().collect(Collectors.groupingBy(RyaStatement::getSubject));
        for (Map.Entry<RyaIRI, List<RyaStatement>> entry : groupedBySubject.entrySet()) {
            try {
                this.updateEntity(entry.getKey(), (Collection<RyaStatement>)entry.getValue());
            }
            catch (IndexingException e) {
                throw new IOException("Failed to update the Entity index.", e);
            }
        }
    }

    private void updateEntity(RyaIRI subject, Collection<RyaStatement> statements) throws IndexingException {
        Objects.requireNonNull(subject);
        Objects.requireNonNull(statements);
        EntityStorage entities = this.entities.get();
        TypeStorage types = this.types.get();
        Preconditions.checkState((entities != null ? 1 : 0) != 0, (Object)"Must set this indexers configuration before storing statements.");
        Preconditions.checkState((types != null ? 1 : 0) != 0, (Object)"Must set this indexers configuration before storing statements.");
        new EntityUpdater(entities).update(subject, old -> {
            Entity.Builder updated;
            if (!old.isPresent()) {
                updated = Entity.builder().setSubject(subject).setVersion(0);
            } else {
                int updatedVersion = ((Entity)old.get()).getVersion() + 1;
                updated = Entity.builder((Entity)old.get()).setVersion(updatedVersion);
            }
            for (RyaStatement statement : statements) {
                if (com.google.common.base.Objects.equal((Object)TYPE_IRI, (Object)statement.getPredicate())) {
                    RyaIRI typeId = new RyaIRI(statement.getObject().getData());
                    updated.setExplicitType(typeId);
                    continue;
                }
                RyaIRI propertyName = statement.getPredicate();
                RyaType propertyValue = statement.getObject();
                try {
                    ConvertingCursor<Type> typesIt = types.search(propertyName);
                    Throwable throwable = null;
                    try {
                        while (typesIt.hasNext()) {
                            RyaIRI typeId = typesIt.next().getId();
                            updated.setProperty(typeId, new Property(propertyName, propertyValue));
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (typesIt == null) continue;
                        if (throwable != null) {
                            try {
                                typesIt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        typesIt.close();
                    }
                }
                catch (IOException | TypeStorage.TypeStorageException e) {
                    throw new RuntimeException("Failed to fetch Types that include the property name '" + statement.getPredicate().getData() + "'.", e);
                }
            }
            return Optional.of(updated.build());
        });
    }

    public void deleteStatement(RyaStatement statement) throws IOException {
        Objects.requireNonNull(statement);
        EntityStorage entities = this.entities.get();
        TypeStorage types = this.types.get();
        Preconditions.checkState((entities != null ? 1 : 0) != 0, (Object)"Must set this indexers configuration before storing statements.");
        Preconditions.checkState((types != null ? 1 : 0) != 0, (Object)"Must set this indexers configuration before storing statements.");
        try {
            new EntityUpdater(entities).update(statement.getSubject(), old -> {
                if (!old.isPresent()) {
                    return Optional.empty();
                }
                Entity oldEntity = (Entity)old.get();
                Entity.Builder updated = Entity.builder(oldEntity);
                updated.setVersion(oldEntity.getVersion() + 1);
                if (TYPE_IRI.equals((Object)statement.getPredicate())) {
                    RyaIRI typeId = new RyaIRI(statement.getObject().getData());
                    if (!oldEntity.getExplicitTypeIds().contains((Object)typeId)) {
                        return Optional.empty();
                    }
                    updated.unsetExplicitType(typeId);
                } else {
                    RyaIRI deletedPropertyName = statement.getPredicate();
                    boolean propertyWasPresent = false;
                    for (RyaIRI typeId : oldEntity.getProperties().keySet()) {
                        for (RyaIRI propertyName : ((ImmutableMap)oldEntity.getProperties().get((Object)typeId)).keySet()) {
                            if (!deletedPropertyName.equals((Object)propertyName)) continue;
                            propertyWasPresent = true;
                            updated.unsetProperty(typeId, deletedPropertyName);
                        }
                    }
                    if (!propertyWasPresent) {
                        return Optional.empty();
                    }
                }
                return Optional.of(updated.build());
            });
        }
        catch (IndexingException e) {
            throw new IOException("Failed to update the Entity index.", e);
        }
    }

    public String getTableName() {
        return null;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public void dropGraph(RyaIRI ... graphs) {
    }

    public Set<IRI> getIndexablePredicates() {
        return null;
    }
}

