/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo.key;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.javatuples.Pair;

public final class MongoDbSafeKey {
    private static final ImmutableList<Pair<String, String>> ESCAPE_CHARACTERS = ImmutableList.of((Object)new Pair((Object)"\\", (Object)"\\\\"), (Object)new Pair((Object)"\\$", (Object)"\\u0024"), (Object)new Pair((Object)".", (Object)"\\u002e"));
    private static final ImmutableList<Pair<String, String>> UNESCAPE_CHARACTERS = ImmutableList.copyOf((Collection)Lists.reverse(ESCAPE_CHARACTERS));

    private MongoDbSafeKey() {
    }

    public static String encodeKey(String key) {
        String encodedKey = key;
        for (Pair pair : ESCAPE_CHARACTERS) {
            String unescapedCharacter = (String)pair.getValue0();
            String escapedCharacter = (String)pair.getValue1();
            encodedKey = encodedKey.replace(unescapedCharacter, escapedCharacter);
        }
        return encodedKey;
    }

    public static String decodeKey(String key) {
        String decodedKey = key;
        for (Pair pair : UNESCAPE_CHARACTERS) {
            String unescapedCharacter = (String)pair.getValue0();
            String escapedCharacter = (String)pair.getValue1();
            decodedKey = decodedKey.replace(escapedCharacter, unescapedCharacter);
        }
        return decodedKey;
    }
}

