/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.storage.mongo.DocumentConverter;
import org.bson.Document;

@DefaultAnnotation(value={NonNull.class})
public class TypeDocumentConverter
implements DocumentConverter<Type> {
    public static final String ID = "_id";
    public static final String PROPERTY_NAMES = "propertyNames";

    @Override
    public Document toDocument(Type type) {
        Objects.requireNonNull(type);
        Document doc = new Document();
        doc.append(ID, (Object)type.getId().getData());
        ArrayList propertyNames = new ArrayList();
        type.getPropertyNames().forEach(field -> propertyNames.add(field.getData()));
        doc.append(PROPERTY_NAMES, propertyNames);
        return doc;
    }

    @Override
    public Type fromDocument(Document document) throws DocumentConverter.DocumentConverterException {
        Objects.requireNonNull(document);
        if (!document.containsKey((Object)ID)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + ID + "' field is missing.");
        }
        if (!document.containsKey((Object)PROPERTY_NAMES)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + PROPERTY_NAMES + "' field is missing.");
        }
        RyaIRI typeId = new RyaIRI(document.getString((Object)ID));
        ImmutableSet.Builder propertyNames = ImmutableSet.builder();
        document.getList((Object)PROPERTY_NAMES, String.class).forEach(propertyName -> propertyNames.add((Object)new RyaIRI(propertyName)));
        return new Type(typeId, (ImmutableSet<RyaIRI>)propertyNames.build());
    }
}

