/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.indexing.entity.storage.mongo.DocumentConverter;
import org.bson.Document;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

@DefaultAnnotation(value={NonNull.class})
public class RyaTypeDocumentConverter
implements DocumentConverter<RyaType> {
    private static final ValueFactory VF = SimpleValueFactory.getInstance();
    public static final String DATA_TYPE = "dataType";
    public static final String VALUE = "value";

    @Override
    public Document toDocument(RyaType ryaType) {
        Objects.requireNonNull(ryaType);
        return new Document().append(DATA_TYPE, (Object)ryaType.getDataType().toString()).append(VALUE, (Object)ryaType.getData());
    }

    @Override
    public RyaType fromDocument(Document document) throws DocumentConverter.DocumentConverterException {
        Objects.requireNonNull(document);
        if (!document.containsKey((Object)DATA_TYPE)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + DATA_TYPE + "' field is missing.");
        }
        if (!document.containsKey((Object)VALUE)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + VALUE + "' field is missing.");
        }
        return new RyaType(VF.createIRI(document.getString((Object)DATA_TYPE)), document.getString((Object)VALUE));
    }
}

