/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.storage.TypeStorage;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.indexing.entity.storage.mongo.DocumentConverter;
import org.apache.rya.indexing.entity.storage.mongo.TypeDocumentConverter;
import org.bson.Document;
import org.bson.conversions.Bson;

@DefaultAnnotation(value={NonNull.class})
public class MongoTypeStorage
implements TypeStorage {
    private static final String COLLECTION_NAME = "entity-types";
    private static final TypeDocumentConverter TYPE_CONVERTER = new TypeDocumentConverter();
    private final MongoClient mongo;
    private final String ryaInstanceName;

    public MongoTypeStorage(MongoClient mongo, String ryaInstanceName) {
        this.mongo = Objects.requireNonNull(mongo);
        this.ryaInstanceName = Objects.requireNonNull(ryaInstanceName);
    }

    @Override
    public void create(Type type) throws TypeStorage.TypeStorageException {
        Objects.requireNonNull(type);
        try {
            this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).insertOne((Object)TYPE_CONVERTER.toDocument(type));
        }
        catch (MongoException e) {
            throw new TypeStorage.TypeStorageException("Failed to create Type with ID '" + type.getId().getData() + "'.", e);
        }
    }

    @Override
    public Optional<Type> get(RyaIRI typeId) throws TypeStorage.TypeStorageException {
        Objects.requireNonNull(typeId);
        try {
            Document document = (Document)this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).find(MongoTypeStorage.makeIdFilter(typeId)).first();
            return document == null ? Optional.empty() : Optional.of(TYPE_CONVERTER.fromDocument(document));
        }
        catch (MongoException | DocumentConverter.DocumentConverterException e) {
            throw new TypeStorage.TypeStorageException("Could not get the Type with ID '" + typeId.getData() + "'.", e);
        }
    }

    @Override
    public ConvertingCursor<Type> search(RyaIRI propertyName) throws TypeStorage.TypeStorageException {
        Objects.requireNonNull(propertyName);
        try {
            Bson byPropertyName = Filters.eq((String)"propertyNames", (Object)propertyName.getData());
            MongoCursor cursor = this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).find(byPropertyName).iterator();
            return new ConvertingCursor<Type>(document -> {
                try {
                    return TYPE_CONVERTER.fromDocument((Document)document);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not convert the Document '" + document + "' into a Type.", e);
                }
            }, (MongoCursor<Document>)cursor);
        }
        catch (MongoException e) {
            throw new TypeStorage.TypeStorageException("Could not fetch Types that include the property '" + propertyName.getData() + "'.", e);
        }
    }

    @Override
    public boolean delete(RyaIRI typeId) throws TypeStorage.TypeStorageException {
        Objects.requireNonNull(typeId);
        try {
            Document deleted = (Document)this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).findOneAndDelete(MongoTypeStorage.makeIdFilter(typeId));
            return deleted != null;
        }
        catch (MongoException e) {
            throw new TypeStorage.TypeStorageException("Could not delete the Type with ID '" + typeId.getData() + "'.", e);
        }
    }

    private static Bson makeIdFilter(RyaIRI typeId) {
        return Filters.eq((String)"_id", (Object)typeId.getData());
    }
}

