/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoClient;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.model.TypedEntity;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.TypeStorage;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.indexing.entity.storage.mongo.DocumentConverter;
import org.apache.rya.indexing.entity.storage.mongo.EntityDocumentConverter;
import org.apache.rya.indexing.entity.storage.mongo.MongoTypeStorage;
import org.apache.rya.indexing.entity.storage.mongo.key.MongoDbSafeKey;
import org.apache.rya.indexing.smarturi.SmartUriException;
import org.apache.rya.indexing.smarturi.duplication.DuplicateDataDetector;
import org.apache.rya.indexing.smarturi.duplication.EntityNearDuplicateException;
import org.bson.Document;
import org.bson.conversions.Bson;

@DefaultAnnotation(value={NonNull.class})
public class MongoEntityStorage
implements EntityStorage {
    protected static final String COLLECTION_NAME = "entity-entities";
    private static final EntityDocumentConverter ENTITY_CONVERTER = new EntityDocumentConverter();
    protected final MongoClient mongo;
    protected final String ryaInstanceName;
    private final DuplicateDataDetector duplicateDataDetector;
    private MongoTypeStorage mongoTypeStorage = null;

    public MongoEntityStorage(MongoClient mongo, String ryaInstanceName) throws EntityStorage.EntityStorageException {
        this(mongo, ryaInstanceName, null);
    }

    public MongoEntityStorage(MongoClient mongo, String ryaInstanceName, DuplicateDataDetector duplicateDataDetector) throws EntityStorage.EntityStorageException {
        this.mongo = Objects.requireNonNull(mongo);
        this.ryaInstanceName = Objects.requireNonNull(ryaInstanceName);
        if (duplicateDataDetector == null) {
            try {
                this.duplicateDataDetector = new DuplicateDataDetector();
            }
            catch (ConfigurationException e) {
                throw new EntityStorage.EntityStorageException("Could not create duplicate data detector.", e);
            }
        } else {
            this.duplicateDataDetector = duplicateDataDetector;
        }
    }

    @Override
    public void create(Entity entity) throws EntityStorage.EntityStorageException {
        Objects.requireNonNull(entity);
        try {
            boolean hasDuplicate = this.detectDuplicates(entity);
            if (hasDuplicate) {
                throw new EntityNearDuplicateException("Duplicate data found and will not be inserted for Entity with Subject: " + entity);
            }
            this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).insertOne((Object)ENTITY_CONVERTER.toDocument(entity));
        }
        catch (MongoException e) {
            ErrorCategory category = ErrorCategory.fromErrorCode((int)e.getCode());
            if (category == ErrorCategory.DUPLICATE_KEY) {
                throw new EntityStorage.EntityAlreadyExistsException("Failed to create Entity with Subject '" + entity.getSubject().getData() + "'.", e);
            }
            throw new EntityStorage.EntityStorageException("Failed to create Entity with Subject '" + entity.getSubject().getData() + "'.", e);
        }
    }

    @Override
    public void update(Entity old, Entity updated) throws EntityStorage.StaleUpdateException, EntityStorage.EntityStorageException {
        Objects.requireNonNull(old);
        Objects.requireNonNull(updated);
        if (!old.getSubject().equals((Object)updated.getSubject())) {
            throw new EntityStorage.EntityStorageException("The old Entity and the updated Entity must have the same Subject. Old Subject: " + old.getSubject().getData() + ", Updated Subject: " + updated.getSubject().getData());
        }
        if (old.getVersion() >= updated.getVersion()) {
            throw new EntityStorage.EntityStorageException("The old Entity's version must be less than the updated Entity's version. Old version: " + old.getVersion() + " Updated version: " + updated.getVersion());
        }
        HashSet<Bson> filters = new HashSet<Bson>();
        filters.add(MongoEntityStorage.makeSubjectFilter(old.getSubject()));
        filters.add(MongoEntityStorage.makeVersionFilter(old.getVersion()));
        Bson oldEntityFilter = Filters.and(filters);
        Document updatedDoc = ENTITY_CONVERTER.toDocument(updated);
        MongoCollection collection = this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME);
        if (collection.findOneAndReplace(oldEntityFilter, (Object)updatedDoc) == null) {
            throw new EntityStorage.StaleUpdateException("Could not update the Entity with Subject '" + updated.getSubject().getData() + ".");
        }
    }

    @Override
    public Optional<Entity> get(RyaIRI subject) throws EntityStorage.EntityStorageException {
        Objects.requireNonNull(subject);
        try {
            Document document = (Document)this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).find(Filters.eq((String)"_id", (Object)subject.getData())).first();
            return document == null ? Optional.empty() : Optional.of(ENTITY_CONVERTER.fromDocument(document));
        }
        catch (MongoException | DocumentConverter.DocumentConverterException e) {
            throw new EntityStorage.EntityStorageException("Could not get the Entity with Subject '" + subject.getData() + "'.", e);
        }
    }

    @Override
    public ConvertingCursor<TypedEntity> search(Optional<RyaIRI> subject, Type type, Set<Property> properties) throws EntityStorage.EntityStorageException {
        Objects.requireNonNull(type);
        Objects.requireNonNull(properties);
        try {
            Set filters = properties.stream().flatMap(property -> MongoEntityStorage.makePropertyFilters(type.getId(), property)).collect(Collectors.toSet());
            filters.add(MongoEntityStorage.makeExplicitTypeFilter(type.getId()));
            MongoCursor cursor = this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).find(Filters.and(filters)).iterator();
            ConvertingCursor.Converter converter = document -> {
                try {
                    Entity entity = ENTITY_CONVERTER.fromDocument((Document)document);
                    Optional<TypedEntity> typedEntity = entity.makeTypedEntity(type.getId());
                    if (!typedEntity.isPresent()) {
                        throw new RuntimeException("Entity with Subject '" + entity.getSubject() + "' could not be cast into Type '" + type.getId() + "'.");
                    }
                    return typedEntity.get();
                }
                catch (DocumentConverter.DocumentConverterException e) {
                    throw new RuntimeException("Document '" + document + "' could not be parsed into an Entity.", e);
                }
            };
            return new ConvertingCursor<TypedEntity>(converter, (MongoCursor<Document>)cursor);
        }
        catch (MongoException e) {
            throw new EntityStorage.EntityStorageException("Could not search Entity.", e);
        }
    }

    @Override
    public boolean delete(RyaIRI subject) throws EntityStorage.EntityStorageException {
        Objects.requireNonNull(subject);
        try {
            Document deleted = (Document)this.mongo.getDatabase(this.ryaInstanceName).getCollection(COLLECTION_NAME).findOneAndDelete(MongoEntityStorage.makeSubjectFilter(subject));
            return deleted != null;
        }
        catch (MongoException e) {
            throw new EntityStorage.EntityStorageException("Could not delete the Entity with Subject '" + subject.getData() + "'.", e);
        }
    }

    private static Bson makeSubjectFilter(RyaIRI subject) {
        return Filters.eq((String)"_id", (Object)subject.getData());
    }

    private static Bson makeVersionFilter(int version) {
        return Filters.eq((String)"version", (Object)version);
    }

    private static Bson makeExplicitTypeFilter(RyaIRI typeId) {
        return Filters.eq((String)"explicitTypeIds", (Object)typeId.getData());
    }

    private static Stream<Bson> makePropertyFilters(RyaIRI typeId, Property property) {
        String propertyName = property.getName().getData();
        String encodedPropertyName = MongoDbSafeKey.encodeKey(propertyName);
        String dataTypePath = Joiner.on((String)".").join((Object[])new String[]{"properties", typeId.getData(), encodedPropertyName, "dataType"});
        String propertyDataType = property.getValue().getDataType().stringValue();
        Bson dataTypeFilter = Filters.eq((String)dataTypePath, (Object)propertyDataType);
        String valuePath = Joiner.on((String)".").join((Object[])new String[]{"properties", typeId.getData(), encodedPropertyName, "value"});
        String propertyValue = property.getValue().getData();
        Bson valueFilter = Filters.eq((String)valuePath, (Object)propertyValue);
        return Stream.of(dataTypeFilter, valueFilter);
    }

    private boolean detectDuplicates(Entity entity) throws EntityStorage.EntityStorageException {
        boolean hasDuplicate = false;
        if (this.duplicateDataDetector.isDetectionEnabled()) {
            List<Entity> comparisonEntities = this.searchHasAllExplicitTypes(entity.getExplicitTypeIds());
            for (Entity compareEntity : comparisonEntities) {
                try {
                    hasDuplicate = this.duplicateDataDetector.compareEntities(entity, compareEntity);
                }
                catch (SmartUriException e) {
                    throw new EntityStorage.EntityStorageException("Encountered an error while comparing entities.", e);
                }
                if (!hasDuplicate) continue;
                break;
            }
        }
        return hasDuplicate;
    }

    private List<Entity> searchHasAllExplicitTypes(ImmutableList<RyaIRI> explicitTypeIds) throws EntityStorage.EntityStorageException {
        ArrayList<Entity> hasAllExplicitTypesEntities = new ArrayList<Entity>();
        if (!explicitTypeIds.isEmpty()) {
            Optional<Type> type;
            RyaIRI firstType = (RyaIRI)explicitTypeIds.get(0);
            ArrayList<RyaIRI> subjects = new ArrayList<RyaIRI>();
            try {
                if (this.mongoTypeStorage == null) {
                    this.mongoTypeStorage = new MongoTypeStorage(this.mongo, this.ryaInstanceName);
                }
                type = this.mongoTypeStorage.get(firstType);
            }
            catch (TypeStorage.TypeStorageException e) {
                throw new EntityStorage.EntityStorageException("Unable to get entity type: " + firstType, e);
            }
            if (type.isPresent()) {
                ConvertingCursor<TypedEntity> cursor = this.search(Optional.empty(), type.get(), Collections.emptySet());
                while (cursor.hasNext()) {
                    TypedEntity typedEntity = cursor.next();
                    RyaIRI subject = typedEntity.getSubject();
                    subjects.add(subject);
                }
            }
            for (RyaIRI subject : subjects) {
                Entity candidateEntity;
                Optional<Entity> entityFromSubject = this.get(subject);
                if (!entityFromSubject.isPresent() || !(candidateEntity = entityFromSubject.get()).getExplicitTypeIds().containsAll(explicitTypeIds)) continue;
                hasAllExplicitTypesEntities.add(candidateEntity);
            }
        }
        return hasAllExplicitTypesEntities;
    }
}

