/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.storage.mongo.DocumentConverter;
import org.apache.rya.indexing.entity.storage.mongo.RyaTypeDocumentConverter;
import org.apache.rya.indexing.entity.storage.mongo.key.MongoDbSafeKey;
import org.bson.Document;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

@DefaultAnnotation(value={NonNull.class})
public class EntityDocumentConverter
implements DocumentConverter<Entity> {
    public static final String SUBJECT = "_id";
    public static final String EXPLICIT_TYPE_IDS = "explicitTypeIds";
    public static final String PROPERTIES = "properties";
    public static final String VERSION = "version";
    public static final String SMART_URI = "smartUri";
    private final RyaTypeDocumentConverter ryaTypeConverter = new RyaTypeDocumentConverter();

    @Override
    public Document toDocument(Entity entity) {
        Objects.requireNonNull(entity);
        Document doc = new Document();
        doc.append(SUBJECT, (Object)entity.getSubject().getData());
        doc.append(EXPLICIT_TYPE_IDS, entity.getExplicitTypeIds().stream().map(explicitTypeId -> explicitTypeId.getData()).collect(Collectors.toList()));
        Document propertiesDoc = new Document();
        for (RyaIRI typeId : entity.getProperties().keySet()) {
            Document typePropertiesDoc = new Document();
            ((ImmutableMap)entity.getProperties().get((Object)typeId)).forEach((propertyNameUri, property) -> {
                String propertyName = property.getName().getData();
                String encodedPropertyName = MongoDbSafeKey.encodeKey(propertyName);
                RyaType value = property.getValue();
                typePropertiesDoc.append(encodedPropertyName, (Object)this.ryaTypeConverter.toDocument(value));
            });
            propertiesDoc.append(typeId.getData(), (Object)typePropertiesDoc);
        }
        doc.append(PROPERTIES, (Object)propertiesDoc);
        doc.append(VERSION, (Object)entity.getVersion());
        doc.append(SMART_URI, (Object)entity.getSmartUri().stringValue());
        return doc;
    }

    @Override
    public Entity fromDocument(Document document) throws DocumentConverter.DocumentConverterException {
        Objects.requireNonNull(document);
        if (!document.containsKey((Object)SUBJECT)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + SUBJECT + "' field is missing.");
        }
        if (!document.containsKey((Object)EXPLICIT_TYPE_IDS)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + EXPLICIT_TYPE_IDS + "' field is missing.");
        }
        if (!document.containsKey((Object)PROPERTIES)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + PROPERTIES + "' field is missing.");
        }
        if (!document.containsKey((Object)VERSION)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + VERSION + "' field is missing.");
        }
        if (!document.containsKey((Object)SMART_URI)) {
            throw new DocumentConverter.DocumentConverterException("Could not convert document '" + document + "' because its '" + SMART_URI + "' field is missing.");
        }
        Entity.Builder builder = Entity.builder().setSubject(new RyaIRI(document.getString((Object)SUBJECT)));
        List explicitTypeIds = document.getList((Object)EXPLICIT_TYPE_IDS, String.class);
        explicitTypeIds.stream().forEach(explicitTypeId -> builder.setExplicitType(new RyaIRI(explicitTypeId)));
        Document propertiesDoc = (Document)document.get((Object)PROPERTIES);
        for (String typeId : propertiesDoc.keySet()) {
            Document typePropertiesDoc = (Document)propertiesDoc.get((Object)typeId);
            for (String propertyName : typePropertiesDoc.keySet()) {
                String decodedPropertyName = MongoDbSafeKey.decodeKey(propertyName);
                Document value = (Document)typePropertiesDoc.get((Object)propertyName);
                RyaType propertyValue = this.ryaTypeConverter.fromDocument(value);
                builder.setProperty(new RyaIRI(typeId), new Property(new RyaIRI(decodedPropertyName), propertyValue));
            }
        }
        builder.setVersion(document.getInteger((Object)VERSION));
        builder.setSmartUri(SimpleValueFactory.getInstance().createIRI(document.getString((Object)SMART_URI)));
        return builder.build();
    }
}

