/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage.mongo;

import com.mongodb.client.MongoCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.bson.Document;

public class ConvertingCursor<T>
implements Iterator<T>,
Closeable {
    private final Converter<T> converter;
    private final MongoCursor<Document> cursor;

    public ConvertingCursor(Converter<T> converter, MongoCursor<Document> cursor) {
        this.converter = Objects.requireNonNull(converter);
        this.cursor = Objects.requireNonNull(cursor);
    }

    @Override
    public boolean hasNext() {
        return this.cursor.hasNext();
    }

    @Override
    public T next() {
        return (T)this.converter.apply(this.cursor.next());
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }

    @FunctionalInterface
    public static interface Converter<R>
    extends Function<Document, R> {
    }
}

