/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.storage;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import java.util.Set;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.indexing.entity.model.Entity;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.model.TypedEntity;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.indexing.mongodb.update.RyaObjectStorage;

@DefaultAnnotation(value={NonNull.class})
public interface EntityStorage
extends RyaObjectStorage<Entity> {
    public ConvertingCursor<TypedEntity> search(Optional<RyaIRI> var1, Type var2, Set<Property> var3) throws EntityStorageException;

    public static class StaleUpdateException
    extends EntityStorageException {
        private static final long serialVersionUID = 1L;

        public StaleUpdateException(String message) {
            super(message);
        }

        public StaleUpdateException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class EntityAlreadyExistsException
    extends EntityStorageException {
        private static final long serialVersionUID = 1L;

        public EntityAlreadyExistsException(String message) {
            super(message);
        }

        public EntityAlreadyExistsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class EntityStorageException
    extends RyaObjectStorage.ObjectStorageException {
        private static final long serialVersionUID = 1L;

        public EntityStorageException(String message) {
            super(message);
        }

        public EntityStorageException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

