/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.query;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.api.resolver.RdfToRyaConversions;
import org.apache.rya.indexing.entity.model.Property;
import org.apache.rya.indexing.entity.model.Type;
import org.apache.rya.indexing.entity.model.TypedEntity;
import org.apache.rya.indexing.entity.storage.EntityStorage;
import org.apache.rya.indexing.entity.storage.mongo.ConvertingCursor;
import org.apache.rya.rdftriplestore.evaluation.ExternalBatchingIterator;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExternalSet;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.CollectionIteration;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultAnnotation(value={NonNull.class})
public class EntityQueryNode
extends ExternalSet
implements ExternalBatchingIterator {
    private static final Logger LOG = LoggerFactory.getLogger(EntityQueryNode.class);
    private static final RyaIRI TYPE_ID_IRI = new RyaIRI(RDF.TYPE.toString());
    private final Type type;
    private final Collection<StatementPattern> patterns;
    private final EntityStorage entities;
    private final boolean subjectIsConstant;
    private final Optional<String> subjectConstant;
    private final Optional<String> subjectVar;
    private final Set<String> bindingNames;
    private final ImmutableMap<RyaIRI, Var> objectVariables;
    private final Set<Property> properties;

    public EntityQueryNode(Type type, Collection<StatementPattern> patterns, EntityStorage entities) throws IllegalStateException {
        this.type = Objects.requireNonNull(type);
        this.patterns = Objects.requireNonNull(patterns);
        this.entities = Objects.requireNonNull(entities);
        this.bindingNames = new HashSet<String>();
        this.properties = new HashSet<Property>();
        EntityQueryNode.verifySameSubjects(patterns);
        EntityQueryNode.verifyAllPredicatesAreConstants(patterns);
        EntityQueryNode.verifyHasCorrectTypePattern(type, patterns);
        EntityQueryNode.verifyAllPredicatesPartOfType(type, patterns);
        Var subject = patterns.iterator().next().getSubjectVar();
        this.subjectIsConstant = subject.isConstant();
        if (this.subjectIsConstant) {
            this.subjectConstant = Optional.of(subject.getValue().toString());
            this.subjectVar = Optional.empty();
        } else {
            this.subjectConstant = Optional.empty();
            this.subjectVar = Optional.of(subject.getName());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (StatementPattern sp : patterns) {
            Var object = sp.getObjectVar();
            Var pred = sp.getPredicateVar();
            RyaIRI predIRI = new RyaIRI(pred.getValue().stringValue());
            this.bindingNames.addAll(sp.getBindingNames());
            if (object.isConstant() && !pred.getValue().equals(RDF.TYPE)) {
                RyaType propertyType = RdfToRyaConversions.convertValue((Value)object.getValue());
                this.properties.add(new Property(predIRI, propertyType));
            }
            builder.put((Object)predIRI, (Object)object);
        }
        this.objectVariables = builder.build();
    }

    public Set<String> getBindingNames() {
        return this.bindingNames;
    }

    public Set<String> getAssuredBindingNames() {
        return this.bindingNames;
    }

    private static void verifySameSubjects(Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(patterns);
        Iterator<StatementPattern> it = patterns.iterator();
        Var subject = it.next().getSubjectVar();
        while (it.hasNext()) {
            StatementPattern pattern = it.next();
            if (pattern.getSubjectVar().equals((Object)subject)) continue;
            throw new IllegalStateException("At least one of the patterns has a different subject from the others. All subjects must be the same.");
        }
    }

    private static void verifyAllPredicatesAreConstants(Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(patterns);
        for (StatementPattern pattern : patterns) {
            if (pattern.getPredicateVar().isConstant()) continue;
            throw new IllegalStateException("The Predicate of a Statement Pattern must be constant. Pattern: " + pattern);
        }
    }

    private static void verifyHasCorrectTypePattern(Type type, Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(type);
        Objects.requireNonNull(patterns);
        boolean typeFound = false;
        for (StatementPattern pattern : patterns) {
            RyaIRI predicate = new RyaIRI(pattern.getPredicateVar().getValue().toString());
            if (!predicate.equals((Object)TYPE_ID_IRI)) continue;
            RyaIRI typeId = new RyaIRI(pattern.getObjectVar().getValue().stringValue());
            if (typeId.equals((Object)type.getId())) {
                typeFound = true;
                continue;
            }
            throw new IllegalStateException("Statement Pattern encountred for a Type that does not match the expected Type. Expected Type = '" + type.getId().getData() + "' Found Type = '" + typeId.getData() + "'");
        }
        if (!typeFound) {
            throw new IllegalStateException("The collection of Statement Patterns that this node matches must define which Type they match.");
        }
    }

    private static void verifyAllPredicatesPartOfType(Type type, Collection<StatementPattern> patterns) throws IllegalStateException {
        Objects.requireNonNull(type);
        Objects.requireNonNull(patterns);
        for (StatementPattern pattern : patterns) {
            RyaIRI predicate = new RyaIRI(pattern.getPredicateVar().getValue().toString());
            if (predicate.equals((Object)TYPE_ID_IRI) || type.getPropertyNames().contains((Object)predicate)) continue;
            throw new IllegalStateException("The Predicate of a Statement Pattern must be a property name for the Type. Type ID: '" + type.getId().getData() + "' Pattern: " + pattern);
        }
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Collection<BindingSet> bindingSets) throws QueryEvaluationException {
        Objects.requireNonNull(bindingSets);
        ArrayList list = new ArrayList();
        bindingSets.forEach(bindingSet -> {
            try {
                list.addAll(this.findBindings((BindingSet)bindingSet));
            }
            catch (Exception e) {
                LOG.error("Unable to evaluate bindingset.", (Throwable)e);
            }
        });
        return new CollectionIteration(list);
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(BindingSet bindingSet) throws QueryEvaluationException {
        Objects.requireNonNull(bindingSet);
        return new CollectionIteration(this.findBindings(bindingSet));
    }

    private List<BindingSet> findBindings(BindingSet bindingSet) throws QueryEvaluationException {
        final MapBindingSet resultSet = new MapBindingSet();
        try {
            ConvertingCursor<TypedEntity> entitiesCursor;
            if (this.subjectIsConstant) {
                String subj = this.subjectConstant.get();
                entitiesCursor = this.entities.search(Optional.of(new RyaIRI(subj)), this.type, this.properties);
            } else {
                entitiesCursor = this.entities.search(Optional.empty(), this.type, this.properties);
            }
            while (entitiesCursor.hasNext()) {
                TypedEntity typedEntity = entitiesCursor.next();
                ImmutableCollection<Property> properties = typedEntity.getProperties();
                for (RyaIRI key : this.objectVariables.keySet()) {
                    Optional<RyaType> prop = typedEntity.getPropertyValue(new RyaIRI(key.getData()));
                    if (!prop.isPresent()) continue;
                    RyaType type = prop.get();
                    String bindingName = ((Var)this.objectVariables.get((Object)key)).getName();
                    resultSet.addBinding(bindingName, (Value)SimpleValueFactory.getInstance().createLiteral(type.getData()));
                }
            }
        }
        catch (EntityStorage.EntityStorageException e) {
            throw new QueryEvaluationException("Failed to evaluate the binding set", (Throwable)e);
        }
        bindingSet.forEach((Consumer)new Consumer<Binding>(){

            @Override
            public void accept(Binding binding) {
                resultSet.addBinding(binding);
            }
        });
        ArrayList<BindingSet> list = new ArrayList<BindingSet>();
        list.add((BindingSet)resultSet);
        return list;
    }

    public Collection<StatementPattern> getPatterns() {
        return this.patterns;
    }

    public int hashCode() {
        return Objects.hash(this.subjectIsConstant, this.type, this.subjectVar, this.subjectConstant, this.getPatterns());
    }

    public boolean equals(Object other) {
        if (other instanceof EntityQueryNode) {
            EntityQueryNode otherNode = (EntityQueryNode)((Object)other);
            boolean samePatterns = this.getPatterns().size() == otherNode.getPatterns().size();
            boolean match = true;
            if (samePatterns) {
                for (StatementPattern sp : this.getPatterns()) {
                    if (otherNode.getPatterns().contains(sp)) continue;
                    match = false;
                    break;
                }
            }
            return Objects.equals(this.subjectIsConstant, otherNode.subjectIsConstant) && Objects.equals(this.subjectVar, otherNode.subjectVar) && Objects.equals(this.type, otherNode.type) && Objects.equals(this.subjectConstant, otherNode.subjectConstant) && samePatterns && match;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: " + this.type.toString());
        sb.append("Statement Patterns:");
        sb.append("-------------------");
        for (StatementPattern sp : this.getPatterns()) {
            sb.append(sp.toString());
        }
        return sb.toString();
    }
}

