/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rya.indexing.entity.model;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.annotation.Immutable;
import org.apache.rya.api.domain.RyaIRI;
import org.apache.rya.api.domain.RyaType;
import org.apache.rya.indexing.entity.model.Property;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class TypedEntity {
    private final RyaIRI subject;
    private final RyaIRI typeId;
    private final boolean explicitlyTyped;
    private final ImmutableMap<RyaIRI, Property> optionalFields;

    private TypedEntity(RyaIRI subject, RyaIRI dataTypeId, boolean explicitlyTyped, ImmutableMap<RyaIRI, Property> optionalFields) {
        this.subject = Objects.requireNonNull(subject);
        this.typeId = Objects.requireNonNull(dataTypeId);
        this.optionalFields = Objects.requireNonNull(optionalFields);
        this.explicitlyTyped = explicitlyTyped;
    }

    public RyaIRI getSubject() {
        return this.subject;
    }

    public RyaIRI getTypeId() {
        return this.typeId;
    }

    public boolean isExplicitlyTyped() {
        return this.explicitlyTyped;
    }

    public ImmutableCollection<Property> getProperties() {
        return this.optionalFields.values();
    }

    public Optional<RyaType> getPropertyValue(RyaIRI propertyName) {
        Objects.requireNonNull(propertyName);
        Property field = (Property)this.optionalFields.get((Object)propertyName);
        return field == null ? Optional.empty() : Optional.of(field.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.typeId, this.optionalFields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof TypedEntity) {
            TypedEntity other = (TypedEntity)o;
            return Objects.equals(this.subject, other.subject) && Objects.equals(this.typeId, other.typeId) && Objects.equals(this.optionalFields, other.optionalFields);
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TypedEntity entity) {
        Objects.requireNonNull(entity);
        Builder builder = TypedEntity.builder().setId(entity.getSubject()).setTypeId(entity.getTypeId());
        entity.getProperties().forEach(builder::setProperty);
        return builder;
    }

    @DefaultAnnotation(value={NonNull.class})
    public static class Builder {
        private RyaIRI subject;
        private RyaIRI typeId;
        private boolean explicitlyTyped = false;
        private final Map<RyaIRI, Property> properties = new HashMap<RyaIRI, Property>();

        public Builder setId(@Nullable RyaIRI subject) {
            this.subject = subject;
            return this;
        }

        public Builder setTypeId(@Nullable RyaIRI typeId) {
            this.typeId = typeId;
            return this;
        }

        public Builder setExplicitelyTyped(boolean explicitlyTyped) {
            this.explicitlyTyped = explicitlyTyped;
            return this;
        }

        public Builder setProperty(@Nullable Property property) {
            if (property != null) {
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        public TypedEntity build() {
            return new TypedEntity(this.subject, this.typeId, this.explicitlyTyped, ImmutableMap.copyOf(this.properties));
        }
    }
}

